/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dplm.ui.util;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.extension.DeploymentManagement;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.swt.graphics.Image;

public class ProvidersLabelProvider implements ILabelProvider {
	
	private DeploymentManagement dplm = null;
	
	public ProvidersLabelProvider(DeploymentManagement dplm){
		super();
		this.dplm = dplm;
	}

	public ProvidersLabelProvider(){
		super();
	}
	
    public Image getImage(Object element) {
    	/*
    	if(element instanceof Device){
	        try {
	        	Device device = (Device)element;
	        	DeploymentProvider dplp = (DeploymentProvider)this.dplm.getDeploymentProvider(device);
				if(dplp.getStatus(device) == DeviceStatus.DEVICE_STATUS_OK_LITERAL){					
				        return DeploymentManagementUIPlugin.getImageDescriptor("icons/phone.gif").createImage();
				} else {
				    // TODO replace the image for providers
				    return DeploymentManagementUIPlugin.getImageDescriptor("icons/disconnected.gif").createImage();
				}
			} catch (MtjException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
        }*/
		return null;
    }

    public String getText(Object element) {
        String name = ""; //$NON-NLS-1$
        if(element instanceof DeploymentProvider){
            name = ((DeploymentProvider)element).getName();
        }
        else if(element instanceof Device)
                name = ((Device)element).getName();
            else
                name = (String)element;
        
        return name;
    }

    public void addListener(ILabelProviderListener listener) {
        // TODO Auto-generated method stub

    }

    public void dispose() {
        // TODO Auto-generated method stub

    }

    public boolean isLabelProperty(Object element, String property) {
        // TODO Auto-generated method stub
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        // TODO Auto-generated method stub

    }
    
    public String getDescription(Object element){
        String name = ""; //$NON-NLS-1$
        if(element instanceof DeploymentProvider){
            name = ((DeploymentProvider)element).getName();
        }
        else if(element instanceof Device)
                name = ((Device)element).getDescription();
            else
                name = (String)element;
        
        return name;
    }

}
