/*******************************************************************************
* Copyright (c) 2006 IBM.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.bp.anttask;

import java.io.File;
import java.util.Properties;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.nature.MtjNature;
import org.eclipse.mtj.extension.devide.project.MtjProject;


public abstract class BuildProviderBaseAntTask extends Task {
	IProgressMonitor monitor=null;
	Properties projectProperties;
	Project myAntProjectReference;
	
	File projectRootDirectory;
	IPath projectRootDirectoryPath;
	String projectName;
	
	IMtjProject mtjProject;
	String natureId;


	public BuildProviderBaseAntTask() {
		super();
	}

	public abstract void run();

	public void execute(IProgressMonitor monitor) throws MtjException
	{
		this.monitor = monitor;
		
		projectProperties = new Properties();
		
		projectProperties.putAll(getProject().getProperties());
		
		Project myProject = getProject();
		
		projectRootDirectory = myProject.getBaseDir();
		projectRootDirectoryPath	= new Path(projectRootDirectory.getAbsolutePath());
		projectName = projectRootDirectoryPath.lastSegment();

		mtjProject = MtjProject.getMtjProject(projectName);
		natureId = MtjNature.getNatureID();

		run();
	}
	public void execute() {
		
		try {
			monitor = (IProgressMonitor) getProject()
			.getReferences().get(AntCorePlugin.ECLIPSE_PROGRESS_MONITOR);	

			execute (monitor);

		} catch (BuildException e) {
			throw e;
		} catch (MtjException e) {
			throw new BuildException (e);
		}
	}
	
	public IFolder convertProjectRelativeLocationToIFolder (String location)
	{
		IProject eclipseProject = mtjProject.getProject();
		IFolder outputFolder = eclipseProject.getFolder(location);

		return outputFolder;
	}

}
