/*******************************************************************************
 * Copyright 2005 Nokia Corporation
 * Copyright (c) 2003-2005 Craig Setera
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: 
 * Nokia - Initial API and implementation 
 * Craig Setera - partial implementation 
*******************************************************************************/

package org.eclipse.mtj.executable.uei;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimesFactory;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.library.MtjCoreLibraryPlugin;
import org.eclipse.mtj.core.library.config.LibrarySpecification;

public class ServiceApiImporter extends AbstractServiceApiImporter {		
	private static IServiceApiImporter instance;
	
	public static IServiceApiImporter getInstance(){		
		if(instance == null){
			instance = new ServiceApiImporter();
		}		
		return instance;
	}
	
	private ServiceApiImporter(){
	}

	public ServiceApi[] getServiceApis(File libraryFile) {
		ArrayList apis = new ArrayList();
		
		try {
			List<LibrarySpecification> lib = MtjCoreLibraryPlugin.getCorrLibrarySpecifications(libraryFile);
			for(int i = 0; i < lib.size(); i++) {
				addOptional(lib.get(i), apis, libraryFile);
			}			
		} catch (CoreException e) {
			e.printStackTrace();
		}
		
		return (ServiceApi[]) apis.toArray(new ServiceApi[apis.size()]);
	}

	/**
	 * @param libs
	 * @param apis
	 * @param libraryFile
	 */
	private void addConfiguration(LibrarySpecification[] libs, ArrayList apis, File libraryFile) {
		for (int i = 0; i < libs.length; i++) {
			DeviceConfiguration api = RuntimesFactory.eINSTANCE.createDeviceConfiguration();
			apis.add(api);
			
			ImplementationRef implRef = RuntimesFactory.eINSTANCE.createImplementationRef();
			implRef.setFileRef(libraryFile.getAbsolutePath());
			api.setImplementation(implRef);
			
			api.setName(libs[i].getName());
			api.setVersion(libs[i].getVersion().toString());
		}
	}

	/**
	 * Add at the optional information for the specified library file.
	 * 
	 * @param zipfile
	 * @param apis
	 */
	private void addOptional(LibrarySpecification lib, ArrayList apis, File libraryFile) {
		ServiceApi api = RuntimesFactory.eINSTANCE.createServiceApi();
			
		if (lib != null) {
			api.setName(lib.getName());
			api.setDescription(lib.getLabel());
			api.setVersion(lib.getVersion().toString());
		}
		else {
			api.setName(libraryFile.getName());
			api.setDescription(Messages.ServiceApiImporter_EmulatorSpecificLibrary);
			api.setVersion(""); //$NON-NLS-1$
		}
			
		ImplementationRef implRef = RuntimesFactory.eINSTANCE.createImplementationRef();
		implRef.setFileRef(libraryFile.getAbsolutePath());
		api.setImplementation(implRef);

		if(lib.getType().equals("api")) //$NON-NLS-1$
			apis.add(api);
	}

	/**
	 * @param libs
	 * @param apis
	 * @param libraryFile
	 */
	private void addProfile(LibrarySpecification[] libs, ArrayList apis, File libraryFile) {
		for (int i = 0; i < libs.length; i++) {
			DeviceProfile api = RuntimesFactory.eINSTANCE.createDeviceProfile();
			apis.add(api);
			
			api.setName(libs[i].getName());
			api.setVersion(libs[i].getVersion().toString());
		}
	}

	/**
	 * Return a boolean indicating whether the specified zip file contains
	 * the specified entry.
	 * 
	 * @param zipFile
	 * @param entryName
	 * @return
	 */
	private boolean zipContainsEntry(ZipFile zipFile, String entryName) {
		return zipFile.getEntry(entryName) != null;
	}

	public DeviceProfile[] getProfileApis(File libraryFile) {
		ArrayList apis = new ArrayList();
		
		try {
			LibrarySpecification[] libs = 
				MtjCoreLibraryPlugin.getLibrarySpecifications(libraryFile, MtjCoreLibraryPlugin.LIBRARY_TYPE_PROFILE);
			if ( libs != null && libs.length > 0 ) {
				addProfile(libs,apis, libraryFile);
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		
		return (DeviceProfile[]) apis.toArray(new DeviceProfile[apis.size()]);
	}

	public DeviceConfiguration[] getConfigurationApis(File libraryFile) {		
		ArrayList apis = new ArrayList();
		
		try {
			LibrarySpecification[] libs = 
				MtjCoreLibraryPlugin.getLibrarySpecifications(libraryFile, MtjCoreLibraryPlugin.LIBRARY_TYPE_CONFIGURATION);
			if ( libs != null && libs.length > 0 ) {
				addConfiguration(libs,apis, libraryFile);
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		
		return (DeviceConfiguration[]) apis.toArray(new DeviceConfiguration[apis.size()]);
	}
}
