/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.swt.widgets.Composite;

/**
 * This extension point is used to add new functionalities to MTJ Development IDE.
 * All MTJ extension point implementers, like Device Platform Provider, that need Administration GUIs, 
 * must do it by implementing the Admin GUI Provider extension point.
 * 
 * </p>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:19 $
 * <br>
 */
public interface AdminGuiProvider extends MtjExtension
{
   
    /**
     * With the method the extension point implementor can create it's admin gui.
     * 
     * @param composite
     * @param style
     * @return
     */
    public Composite create(Composite composite, int style) throws MtjException;
   
   /**
    * Method returns reference to the master extension, like Device Platform Provider.
    * 
    * @return
    */
    public MtjExtension getOwner() throws MtjException;
   
    /**
     * With the method the extension point implementor can create it's PreferencePage.
     * 
     * @return
     */
    public PreferencePage getPreferencePage();
}
