/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension;

/**
 * Localization Provider is responsible to give localized Strings and Messages.
 * 
 * </p>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:20 $
 * <br>
 */
public interface LocalizationProvider {

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public String getString(String key);
	
	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.  Substitutions will be made if
	 * supplied.
	 * 
	 * @param key
	 * @param substitutions
	 * @return String
	 */
	public String getString(String key, Object[] substitutions);
	
	/**
	 * Returns the UiString from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public String getUiString(String key);
	
	/**
	 * Returns the UiString from the plugin's resource bundle,
	 * or 'key' if not found.  Substitutions will be made if
	 * supplied.
	 * 
	 * @param key
	 * @param substitutions
	 * @return String
	 */
	public String getUiString(String key, Object[] substitutions);
	
}
