/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.api.model.preverifier;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

/**
 * Interface representing field level information
 * in a preverification error.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:21 $
 * <br>
 * @author Craig Setera
 */
public interface IMethodErrorInformation {
	/**
	 * Return the name of the method in which the error occurred.
	 * 
	 * @return
	 */
	String getName();

	/**
	 * Return the type description information for the field in which the
	 * error occurred.
	 * 
	 * @return
	 */
	String getTypeDescription();
	
	/**
	 * Get the method based on the method information.
	 * 
	 * @param type
	 * @return
	 */
	public IMethod getTypeMethod(IType type);

}
