/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
 * Copyright (c) 2003-2005 Craig Setera
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Nokia -  Partial implementation
 * Craig Setera - Initial API and implementation
 * 

*******************************************************************************/
package org.eclipse.mtj.core;

public class IMtjCoreConstants {

	// The plugin ID
	public static final String PLUGIN_ID = "org.eclipse.mtj.core"; //$NON-NLS-1$
	
	// Directory preference keys and defaults
	public static final String PREF_DEPLOYMENT_DIR = "deployment_dir"; //$NON-NLS-1$
	public static final String PREF_VERIFIED_DIR = "verified_dir"; //$NON-NLS-1$
	
	// New project creation preferences
	public static final String PREF_USE_RESOURCES_DIR = "use_resources_dir"; //$NON-NLS-1$
	public static final String PREF_RESOURCES_DIR = "resources_dir"; //$NON-NLS-1$
	public static final String PREF_FORCE_JAVA11 = "force_java11"; //$NON-NLS-1$
	
	// Over the Air preferences
	public static final String PREF_OTA_SERVER_START_AT_START = "ota_start_at_start"; //$NON-NLS-1$
	public static final String PREF_OTA_PORT_DEFINED = "ota_port_defined"; //$NON-NLS-1$
	public static final String PREF_OTA_PORT = "ota_port"; //$NON-NLS-1$
	public static final String PREF_OTA_AUTODEPLOY = "ota_autodeploy"; //$NON-NLS-1$
	
	// Proguard obfuscation preferences
	public static final String PREF_OBFUSCATION_USE_PROJECT = "obfuscate_use_project"; //$NON-NLS-1$
	public static final String PREF_PROGUARD_DIR = "proguard_dir"; //$NON-NLS-1$
	public static final String PREF_PROGUARD_USE_SPECIFIED = "proguard_use_specified"; //$NON-NLS-1$
	public static final String PREF_PROGUARD_OPTIONS = "proguard_options"; //$NON-NLS-1$
	public static final String PREF_PROGUARD_KEEP = "proguard_keep"; //$NON-NLS-1$
	
	// Packaging related preferences
	public static final String PREF_PKG_USE_PROJECT = "pkg_use_project"; //$NON-NLS-1$
	public static final String PREF_PKG_AUTOVERSION = "pkg_autoversion"; //$NON-NLS-1$
	public static final String PREF_PKG_EXCLUDED_PROPS = "pkg_excluded_props"; //$NON-NLS-1$
	
	// Preverifier related preferences
	public static final String PREF_PREVERIFY_USE_PROJECT = "pkg_use_project"; //$NON-NLS-1$

	public static final String PREF_PREVERIFY_CONFIG_LOCATION = "preverify_config_location"; //$NON-NLS-1$
	public static final String PREF_PREVERIFY_CONFIG_VALUE = "preverify_config_value"; //$NON-NLS-1$
	public static final String PREF_PREVERIFY_BUILT_IN = "preverify_use_built_in"; //$NON-NLS-1$
	
	public static final String PREF_PREVERIFY_CONFIG_LOCATION_JAD = "jad"; //$NON-NLS-1$
	public static final String PREF_PREVERIFY_CONFIG_LOCATION_PLATFORM = "platform"; //$NON-NLS-1$
	public static final String PREF_PREVERIFY_CONFIG_LOCATION_SPECIFIED = "specified"; //$NON-NLS-1$
	
	// Miscellaneous preferences
	public static final String PREF_RMTDBG_DELAY = "rmt_debug_delay"; //$NON-NLS-1$
	public static final String PREF_ANTENNA_JAR = "antenna_jar"; //$NON-NLS-1$
	
	// Debugging property keys
	// Key that uses "true" or "false" to control whether or not
	// to dump the launch command line for the emulator
	public static final String PROP_DUMP_LAUNCH = "org.eclipse.mtj.debug.dump.launch"; //$NON-NLS-1$
	
	// Key that uses "true" or "false" to control whether or not
	// to log the complete information that is returned from running the
	// preverifier executable
	public static final String PROP_LOG_PREVERIFICATION = "org.eclipse.mtj.core.log.preverification"; //$NON-NLS-1$
	
	// Key that uses "true" or "false" to control whether or not
	// to write the stdout stream of the obfuscation process to 
	// the log file.
	public static final String PROP_LOG_OBFUSCATION_STDOUT = "org.eclipse.mtj.core.log.obfuscation"; //$NON-NLS-1$
	
	// The superclass of all midlets
	public static final String MIDLET_SUPERCLASS = "javax.microedition.midlet.MIDlet"; //$NON-NLS-1$
	
	// Miscellaenous
	public static final String PROGUARD_JAR = "proguard.jar"; //$NON-NLS-1$

	public static final String J2ME_NATURE_ID = PLUGIN_ID + ".nature"; //$NON-NLS-1$
	public static final String J2ME_PREVERIFIER_ID = PLUGIN_ID + ".preverifier"; //$NON-NLS-1$
	public static final String J2ME_PREPROCESSOR_ID = PLUGIN_ID + ".preprocessor"; //$NON-NLS-1$
	public static final String J2ME_TOOLKIT_TYPES_ID = "wirelessToolkitTypes"; //$NON-NLS-1$
	public static final String J2ME_CONFIGURATIONS_ID = "configurations"; //$NON-NLS-1$
	public static final String J2ME_PROFILES_ID = "profiles"; //$NON-NLS-1$
	
	//////////////////////////////////////////////////////////////////////
	// Error messages
	//////////////////////////////////////////////////////////////////////
	/** No midlets defined during OTA launch */
	public static final int ERR_OTA_NO_MIDLETS = 100;
	
	/** Errors occurred during obfuscation */
	public static final int ERR_OBFUSCATION_ERRORS = 101;
	
	/** Error searching for jar executable */
	public static final int ERR_COULD_NOT_FIND_JAR_TOOL = 102;
	
	/** Need signature passwords (not really an error, but triggers a dialog) */
	public static final int INFO_NEED_SIGNATURE_PASSWORDS = 103;
}
