/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
 * Copyright (c) 2003-2005 Craig Setera
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.core.jad;
/**
 * Constants related to editting JAD files.
 * <p>
 * <b>Note:</b> This class/interface is part of an interim API that is still under development and expected to
 * change before reaching stability. It is being made available at this early stage to solicit feedback
 * from pioneering adopters on the understanding that any code that uses this API will almost 
 * certainly be broken as the API evolves.
 * </p>
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:23 $
 * <br>
 * @author Craig Setera
 */
public interface IJADConstants {
	// Information garnered from WTK tool...
	//	Required:
	public static final String JAD_MIDLET_JAR_SIZE = 
		"MIDlet-Jar-Size"; //$NON-NLS-1$
	public static final String JAD_MIDLET_JAR_URL = 
		"MIDlet-Jar-URL"; //$NON-NLS-1$
	public static final String JAD_MIDLET_NAME = 
		"MIDlet-Name"; //$NON-NLS-1$
	public static final String JAD_MIDLET_VENDOR = 
		"MIDlet-Vendor"; //$NON-NLS-1$
	public static final String JAD_MIDLET_VERSION = 
		"MIDlet-Version"; //$NON-NLS-1$
	public static final String JAD_MICROEDITION_CONFIG = 
		"MicroEdition-Configuration"; //$NON-NLS-1$
	public static final String JAD_MICROEDITION_PROFILE =
		"MicroEdition-Profile"; //$NON-NLS-1$

	//	Optional:
	public static final String JAD_MIDLET_DATA_SIZE = 
		"MIDlet-Data-Size"; //$NON-NLS-1$
	public static final String JAD_MIDLET_DELETE_CONFIRM =
		"MIDlet-Delete-Confirm"; //$NON-NLS-1$
	public static final String JAD_MIDLET_DELETE_NOTIFY =
		"MIDlet-Delete-Notify"; //$NON-NLS-1$
	public static final String JAD_MIDLET_DESCRIPTION = 
		"MIDlet-Description"; //$NON-NLS-1$
	public static final String JAD_MIDLET_ICON = 
		"MIDlet-Icon"; //$NON-NLS-1$
	public static final String JAD_MIDLET_INFO_URL = 
		"MIDlet-Info-URL"; //$NON-NLS-1$
	public static final String JAD_MIDLET_INSTALL_NOTIFY =
		"MIDlet-Install-Notify"; //$NON-NLS-1$
	
	// The permission properties
	public static final String JAD_MIDLET_PERMISSIONS =
		"MIDlet-Permissions"; //$NON-NLS-1$
	public static final String JAD_MIDLET_PERMISSIONS_OPTIONAL =
		"MIDlet-Permissions-Opt"; //$NON-NLS-1$
	
	// Signature-related:
	public static final String JAD_MIDLET_JAR_RSA_SHA1 =
		"MIDlet-Jar-RSA-SHA1"; //$NON-NLS-1$
	
	public static final String JAD_MIDLET_CERTIFICATE =
		"MIDlet-Certificate-1-";	// (needs "N" appended to it) //$NON-NLS-1$
}
