/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.preferences;

import java.io.IOException;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.mtj.core.ui.Messages;

/**
 * 
 *
 */
public class PluginPreferenceStore implements IPersistentPreferenceStore {
	/**
	 * The core runtime preference store; 
	 * 
	 */
	private Preferences prefs = null;

	/** The owner of the preferences being wrapped */
	private Plugin owner;
	
	private ListenerList listeners = new ListenerList();
	
	/**
	 * Boolean indicator for the listener.
	 */
	private boolean listenerAdded = false;
	
	/**
	 * Indicates whether property change events should be suppressed 
	 */
	private boolean quietMode = false;	
	/**
	 * 
	 */
	public PluginPreferenceStore() {
		super();
		// TODO Auto-generated constructor stub
	}
	public PluginPreferenceStore(Plugin ownerPlugin, Preferences pluginPreferences) {
		super();
		this.owner = ownerPlugin;
		prefs = pluginPreferences;		
		// TODO Auto-generated constructor stub
	}

	/**
	 * Initializes this preference store.
	 */
	void initialize() {
		// ensure initialization is only done once.
		if (this.prefs != null) {
			return;
		}

		// avoid adding the listener a second time when reentered
		if (!this.listenerAdded) {
			// register listener that funnels everything to firePropertyChangeEvent
			this
				.prefs
				.addPropertyChangeListener(
					new Preferences
					.IPropertyChangeListener() {
				public void propertyChange(
					Preferences.PropertyChangeEvent event) {
					if (!quietMode) {
						firePropertyChangeEvent(
							event.getProperty(),
							event.getOldValue(),
							event.getNewValue());
					}
				}
			});
			this.listenerAdded = true;
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPersistentPreferenceStore#save()
	 */
	public void save() throws IOException {
		owner.savePluginPreferences();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#addPropertyChangeListener(org.eclipse.jface.util.IPropertyChangeListener)
	 */
	public void addPropertyChangeListener(IPropertyChangeListener listener) {
		listeners.add(listener);

	}
	/* (non-javadoc)
	 * Method declared on IPreferenceStore
	 */
	public void removePropertyChangeListener(IPropertyChangeListener listener) {
		listeners.remove(listener);
	}


	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#firePropertyChangeEvent(java.lang.String, java.lang.Object, java.lang.Object)
	 */
	public void firePropertyChangeEvent(String name, Object oldValue,
			Object newValue) {

		// efficiently handle case of 0 listeners
		if (listeners.isEmpty()) {
			// no one interested
			return;
		}
		/**
		 * important: create intermediate array to protect against listeners
		 * being added/removed during the notification
		 */
		final Object[] list = listeners.getListeners();
		final org.eclipse.jface.util.PropertyChangeEvent event =
			new org.eclipse.jface.util.PropertyChangeEvent(this, name, oldValue, newValue);
		for (int i = 0; i < list.length; i++) {
			final IPropertyChangeListener listener = (IPropertyChangeListener) list[i];
			Platform.run(new SafeRunnable(Messages.PluginPreferenceStore_PreferenceChangeError) {
				public void run() {
					listener.propertyChange(event);
				}
			});
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#contains(java.lang.String)
	 */
	public boolean contains(String name) {
		return getPrefs().contains(name);
	}


	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getBoolean(java.lang.String)
	 */
	public boolean getBoolean(String name) {
		return getPrefs().contains(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getDefaultBoolean(java.lang.String)
	 */
	public boolean getDefaultBoolean(String name) {
		return getPrefs().getDefaultBoolean(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getDefaultDouble(java.lang.String)
	 */
	public double getDefaultDouble(String name) {
		return getPrefs().getDefaultDouble(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getDefaultFloat(java.lang.String)
	 */
	public float getDefaultFloat(String name) {
		return getPrefs().getDefaultFloat(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getDefaultInt(java.lang.String)
	 */
	public int getDefaultInt(String name) {
		return getPrefs().getDefaultInt(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getDefaultLong(java.lang.String)
	 */
	public long getDefaultLong(String name) {
		return getPrefs().getDefaultLong(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getDefaultString(java.lang.String)
	 */
	public String getDefaultString(String name) {
		return getPrefs().getDefaultString(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getDouble(java.lang.String)
	 */
	public double getDouble(String name) {
		return getPrefs().getDouble(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getFloat(java.lang.String)
	 */
	public float getFloat(String name) {
		return getPrefs().getFloat(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getInt(java.lang.String)
	 */
	public int getInt(String name) {
		return getPrefs().getInt(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getLong(java.lang.String)
	 */
	public long getLong(String name) {
		return getPrefs().getLong(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#getString(java.lang.String)
	 */
	public String getString(String name) {
		return getPrefs().getString(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#isDefault(java.lang.String)
	 */
	public boolean isDefault(String name) {
		return getPrefs().isDefault(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#needsSaving()
	 */
	public boolean needsSaving() {
		return getPrefs().needsSaving();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#putValue(java.lang.String, java.lang.String)
	 */
	public void putValue(String name, String value) {
		try {
			/**
			 * temporarily suppress event 
			 * notifications while setting value
			 */ 
			quietMode = true;
			getPrefs().setValue(name, value);
		} finally {
			quietMode = false;
		}

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setDefault(java.lang.String, double)
	 */
	public void setDefault(String name, double value) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setDefault(java.lang.String, float)
	 */
	public void setDefault(String name, float value) {
		getPrefs().setDefault(name, value);

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setDefault(java.lang.String, int)
	 */
	public void setDefault(String name, int value) {
		getPrefs().setDefault(name, value);

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setDefault(java.lang.String, long)
	 */
	public void setDefault(String name, long value) {
		getPrefs().setDefault(name, value);

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setDefault(java.lang.String, java.lang.String)
	 */
	public void setDefault(String name, String defaultObject) {
		getPrefs().setDefault(name, defaultObject);

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setDefault(java.lang.String, boolean)
	 */
	public void setDefault(String name, boolean value) {
		getPrefs().setDefault(name, value);		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setToDefault(java.lang.String)
	 */
	public void setToDefault(String name) {
		getPrefs().setToDefault(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setValue(java.lang.String, double)
	 */
	public void setValue(String name, double value) {
		getPrefs().setDefault(name, value);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setValue(java.lang.String, float)
	 */
	public void setValue(String name, float value) {
		getPrefs().setDefault(name, value);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setValue(java.lang.String, int)
	 */
	public void setValue(String name, int value) {
		getPrefs().setDefault(name, value);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setValue(java.lang.String, long)
	 */
	public void setValue(String name, long value) {
		getPrefs().setDefault(name, value);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setValue(java.lang.String, java.lang.String)
	 */
	public void setValue(String name, String value) {
		getPrefs().setDefault(name, value);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceStore#setValue(java.lang.String, boolean)
	 */
	public void setValue(String name, boolean value) {
		getPrefs().setDefault(name, value);
	}
	/**
	 * Returns the underlying preference store.
	 * 
	 * @return the underlying preference store
	 */
	private Preferences getPrefs() {
		if (prefs == null) {
			// although we try to ensure initialization is done eagerly,
			// this cannot be guaranteed, so ensure it is done here
			initialize();
		}
		return prefs;
	}


}
