/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.core.ui.preferences.model;

import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.swt.widgets.Composite;

public class ExtensionImplNode {
	public String name;
	public String vendor;
	public String version;
	public String active;
	public Object impl;
	public Composite adminPage;
	public ExtensionNode parent;
	public ExtensionImplNode(String name, Object impl) {
		this.name = name;
		this.impl = impl;
		this.vendor = ((MtjExtension)impl).getVendor();
		this.version = ((MtjExtension)impl).getVersion();
		this.active = Boolean.toString(((MtjExtension)impl).isActive());
	}
	public String toString() {
		if ( impl instanceof MtjExtension ) {
			MtjExtension m = (MtjExtension)impl;
			return (m.isActive() ? Messages.ExtensionImplNode_Active : Messages.ExtensionImplNode_NotActive) + m.getVendor() + ", " + m.getVersion();  //$NON-NLS-1$
		}
		else {
			return name;
		}
	}
	/**
	 * @return Returns the adminPage.
	 */
	public Composite getAdminPage() {
		return adminPage;
	}
	/**
	 * @param adminPage The adminPage to set.
	 */
	public void setAdminPage(Composite adminPage) {
		this.adminPage = adminPage;
	}
	/**
	 * @return Returns the impl.
	 */
	public Object getImpl() {
		return impl;
	}
	/**
	 * @param impl The impl to set.
	 */
	public void setImpl(Object impl) {
		this.impl = impl;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the active.
	 */
	public String getActive() {
		return active;
	}
	/**
	 * @param active The active to set.
	 */
	public void setActive(String active) {
		this.active = active;
	}
	/**
	 * @return Returns the parent.
	 */
	public ExtensionNode getParent() {
		return parent;
	}
	/**
	 * @param parent The parent to set.
	 */
	public void setParent(ExtensionNode parent) {
		this.parent = parent;
	}
	/**
	 * @return Returns the vendor.
	 */
	public String getVendor() {
		return vendor;
	}
	/**
	 * @param vendor The vendor to set.
	 */
	public void setVendor(String vendor) {
		this.vendor = vendor;
	}
	/**
	 * @return Returns the version.
	 */
	public String getVersion() {
		return version;
	}
	/**
	 * @param version The version to set.
	 */
	public void setVersion(String version) {
		this.version = version;
	}
}
	