/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.preferences.model;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.swt.graphics.Image;

public class ExtensionLabelProvider extends LabelProvider implements
		ITableLabelProvider {

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
	 */
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
	 */
	public String getColumnText(Object element, int columnIndex) {

		if ( element instanceof MtjExtension ) {
			MtjExtension m = (MtjExtension)element;
			return (m.isActive() ? Messages.ExtensionLabelProvider_Active : Messages.ExtensionLabelProvider_NotActive ) + MtjServices.getInstance().capitalizeIdentifier( m.getType().toString() ) + Messages.ExtensionLabelProvider_Vendor + m.getVendor() + Messages.ExtensionLabelProvider_Version + m.getVersion();
		}
		else if (element instanceof ExtensionImplNode) {
			ExtensionImplNode myTableElement = (ExtensionImplNode) element;

			if (columnIndex == 0)
				return myTableElement.getName();

			if (columnIndex == 1)
				return myTableElement.getVendor();
		
			if (columnIndex == 2)
				return myTableElement.getVersion();
		
			if (columnIndex == 3) {
				if ( ( (MtjExtension)myTableElement.getImpl() ).isActive() ){
					myTableElement.setActive("TRUE"); //$NON-NLS-1$
				} else {
					myTableElement.setActive("FALSE"); //$NON-NLS-1$
				}
				return myTableElement.getActive();
			}
								
		}
		return ""; //$NON-NLS-1$
	}

}
