/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.preferences.view;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.core.ui.preferences.model.MtjProjectContentProvider;
import org.eclipse.mtj.core.ui.preferences.model.MtjProjectLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class ProjectScopeDialog extends StatusDialog {
	// the visual selection widget group
	private CheckboxTableViewer fTableViewer;
	private Set fProjectsWithSpecifics;

	// sizing constants
	private final static int SIZING_SELECTION_WIDGET_HEIGHT= 250;
	private final static int SIZING_SELECTION_WIDGET_WIDTH= 300;
	
	private final static String DIALOG_SETTINGS_SHOW_ALL= "ProjectScopeDialog.show_all"; //$NON-NLS-1$

	private ViewerFilter fFilter;

	private IJavaProject[] selectionResult = null;
	
	private IJavaProject[] fSourceProjects = null;
	
	private boolean doFilter = false;
	
	/**
     * A constructor for ProjectScopeDialog
     * @param shell
     * @param title
     * @param node
     */
    public ProjectScopeDialog(Shell shell, String title,  Set projectsWithSpecifics, IJavaProject[] _projects){
		super(shell);
		setTitle(title);
		
		//setMessage("MTJ ProjectSelectionDialog_desciption"); 
		
		fProjectsWithSpecifics= projectsWithSpecifics;
		fSourceProjects = _projects;
		
        int shellStyle = getShellStyle();
        setShellStyle(shellStyle | SWT.MAX | SWT.RESIZE);
		
		fFilter= new ViewerFilter() {
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				return fProjectsWithSpecifics.contains(element);
			}
		};
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent){

		// page group
		Composite composite= (Composite) super.createDialogArea(parent);

		Font font= parent.getFont();
		composite.setFont(font);

		//createMessageArea(composite);

		//fTableViewer= new TableViewer(composite, SWT.CHECK| SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
		fTableViewer= CheckboxTableViewer.newCheckList(composite, SWT.BORDER);
				//composite, SWT.CHECK| SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
		
		fTableViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				Object[] _selected = ((IStructuredSelection) event.getSelection()).toArray();
				doSelectionChanged( _selected );
			}
		});
		fTableViewer.addCheckStateListener(new ICheckStateListener() {
             public void checkStateChanged(CheckStateChangedEvent e) {
                 //doCheckStateChanged(e);
            	 CheckboxTableViewer source = (CheckboxTableViewer)e.getSource();
            	 for (int ix = 0; ix < source.getTable().getItems().length; ix++){
            		 
            		 if ( ((IJavaProject)((TableItem)source.getTable().getItems()[ix]).getData()).equals( (IJavaProject)e.getElement()) ) {
            			 fTableViewer.getTable().select( ix );
            		 }
            	 }
             }
         });
		/*
		fTableViewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
                okPressed();
			}
		});
		*/
		GridData data= new GridData(SWT.FILL, SWT.FILL, true, true);
		data.heightHint= SIZING_SELECTION_WIDGET_HEIGHT;
		data.widthHint= SIZING_SELECTION_WIDGET_WIDTH;
		
		fTableViewer.getTable().setLayoutData(data);

		fTableViewer.setLabelProvider(new MtjProjectLabelProvider());
		fTableViewer.setContentProvider(new MtjProjectContentProvider(fProjectsWithSpecifics));
		//fTableViewer.setSorter(new MtjProjectSorter());
		fTableViewer.getControl().setFont(font);

		/*
		
		Button checkbox= new Button(composite, SWT.CHECK);
		checkbox.setText("CLDC projects"); 
		checkbox.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, true, false));
		checkbox.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				updateFilter(((Button) e.widget).getSelection());
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				updateFilter(((Button) e.widget).getSelection());
			}
		});
		*/
		IDialogSettings dialogSettings= JavaPlugin.getDefault().getDialogSettings();
		//boolean doFilter= !dialogSettings.getBoolean(DIALOG_SETTINGS_SHOW_ALL) && !fProjectsWithSpecifics.isEmpty();
		//checkbox.setSelection(doFilter);
		
		updateFilter(doFilter);
		
		//IJavaModel input= JavaCore.create(ResourcesPlugin.getWorkspace().getRoot());
		fTableViewer.setInput(parent); //input
		
		fTableViewer.getTable().setSelection(0);
		doSelectionChanged(fTableViewer.getTable().getSelection());
		Dialog.applyDialogFont(composite);
		
		//getOKButton().setEnabled(true);
		
		return composite;
		/*
		try {
				return null;

		} catch (Exception ex) {
    		MtjCoreUiPlugin.getDefault().displayError(getShell(),1,1,"Error","Project Specific settings",ex );
			ex.printStackTrace();
		}
		return null;
		*/
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createButtonBar(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createButtonBar(Composite parent) {
		Control control = super.createButtonBar(parent);			
		return control;
		
	}
	protected void updateFilter(boolean selected) {
		if (selected) {
			fTableViewer.addFilter(fFilter);
		} else {
			fTableViewer.removeFilter(fFilter);
		}
		JavaPlugin.getDefault().getDialogSettings().put(DIALOG_SETTINGS_SHOW_ALL, !selected);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	@Override
	protected void okPressed() {
		HashSet projects = new HashSet();
		try {		
			for (int idx = 0; idx < fTableViewer.getTable().getItemCount(); idx++) {		

				TableItem _item = fTableViewer.getTable().getItem(idx);
				if (_item.getChecked() ) {
					IJavaProject _jp = (IJavaProject)_item.getData();
					projects.add(_jp);					
				}
			}

			if (projects.size() >0) {
					Object[] _obj = projects.toArray();
					IJavaProject[] _prj = new IJavaProject[_obj.length]; 
					for (int i=0; i < _obj.length; i++){
						_prj[i] = (IJavaProject)_obj[i];
					}
					setSelectionResult(_prj);
			} else {
					setSelectionResult(null);
			}
		} catch (Exception ex) {
				MtjCoreUiPlugin.displayError(MtjCorePlugin.getDefault().getActiveShell(),1,1,Messages.ProjectScopeDialog_Error,Messages.ProjectScopeDialog_ErrorOccurred, ex);				
		}
	
		super.okPressed();
	}

	private void doSelectionChanged(Object[] objects) {
		if (objects.length != 1) {
			updateStatus(new StatusInfo(IStatus.ERROR, "")); //$NON-NLS-1$
			//setSelectionResult(null);
		} else {
			updateStatus(new StatusInfo()); //$NON-NLS-1$			
			//setSelectionResult(objects);
		}
	}
	private void setSelectionResult(IJavaProject[] obj){
		selectionResult = obj;
	}
	public IJavaProject[] getSelectionResult() {
		return selectionResult;
	}

}
