/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.core.ui.util;

import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CompositeDialog extends TitleAreaDialog {
	private CompositePrototype composite;
	private DialogController dialogController;
	
	private String title;
	private String message;
	
	private String titleBarLabel = null;
	
	private Composite c;

	/**
	 * Default constructor.  Initializes the Dialog and the Title area with data.
	 * 
	 * @param parent
	 * @param composite
	 * @param dialogController
	 * @param title
	 * @param message
	 */
	public CompositeDialog(Shell parent, CompositePrototype composite, DialogController dialogController, String title, String message) {
		super(parent);
		this.setShellStyle(getShellStyle() | SWT.MAX | SWT.RESIZE);
		this.composite = composite;
		this.dialogController = dialogController;
		this.title = title;
		this.message = message;
	}
	
	/**
	 * Optional constructor that also initializes the Title Bar area of the dialog.  The title and message refer to the top data area.
	 * This is not the default, because we want to use default behavior for the titleBarLabel if the user does not specify it.
	 * 
	 * @param parent
	 * @param composite
	 * @param dialogController
	 * @param titleBarLabel
	 * @param title
	 * @param message
	 */
	public CompositeDialog(Shell parent, CompositePrototype composite, DialogController dialogController, String titleBarLabel, String title, String message) {
		this (parent, composite, dialogController, title, message);
		setTitleBarLabel( titleBarLabel);
	}
		
	
	/**
	 * Provide a way for the user to set the label on the title bar as opposed to the title in the top of the dialog that is also
	 * referred to as the title.
	 * @param title
	 */
	public void setTitleBarLabel (String title)
	{
		titleBarLabel = new String (title);
	}
	
	public Composite getDefaultComposite() {
		return c;
	}
	
	protected Control createDialogArea(Composite parent) {
		this.setBlockOnOpen(true);
		Composite container = (Composite) super.createDialogArea(parent);
		container.setLayout(new GridLayout());
		container.setLayoutData(new GridData(GridData.FILL_BOTH));

		setMessage(message, IMessageProvider.INFORMATION);

		c = composite.clone();
		c.setParent(container);
		return c;
	}
	
	protected void okPressed() {
		if(this.dialogController != null)
			dialogController.handleOK();
		super.okPressed();
	}
	
	public static CompositeDialog createDialog(Composite composite, DialogController controller,String title,String message) {
		class composite implements CompositePrototype {
			private Composite c;
			private DialogController controller;
			
			public composite(Composite c, DialogController controller) {
				this.c = c; 
				this.controller = controller; 									
			}
			
			public Composite clone() {
				return c;
			}	
			
			public DialogController getController() {
				return controller; 
			}
		}

		composite c = new composite(composite, controller);
		CompositeDialog d = new CompositeDialog(composite.getShell(),c,c.getController(),title,message);
		return d;
	}
	
	@Override
	protected void configureShell(Shell newShell) {
		// TODO Auto-generated method stub
		super.configureShell(newShell);
		if (titleBarLabel != null)
			newShell.setText(titleBarLabel);
	}
	
	
}
