/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 
package org.eclipse.mtj.core.ui.util;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.IJavaElementSearchConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

	/**
	 * A simple helper class for creating a Type selection dialog
	 * that allows for selection of Midlet subclasses.
	 */
	public class ExecutableSelectionDialogCreator {

		/**
		 * Create a new midlet selection dialog.
		 * 
		 * @param shell
		 * @param context
		 * @param javaProject
		 * @param multipleSelect
		 * @return
		 * @throws JavaModelException
		 */
		public static SelectionDialog createExecutableSelectionDialog(
				Shell shell,
				IRunnableContext context,
				IJavaSearchScope searchScope,
				boolean multipleSelect) 
					throws JavaModelException
		{
			SelectionDialog dialog =
				JavaUI.createTypeDialog(
					shell,
					context,
					searchScope,
					IJavaElementSearchConstants.CONSIDER_CLASSES_AND_INTERFACES,	
					multipleSelect,
					"*");  //$NON-NLS-1$

			dialog.setTitle(Messages.launchtab_executable_search_dialog_title);
			dialog.setMessage(Messages.launchtab_executable_search_dialog_message);
			
			return dialog;
		}
		
		// Private constructor for static access
		private ExecutableSelectionDialogCreator() {}
	}
