/**
 * 
 */
package org.eclipse.mtj.extension.smgmt.impl.j9;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.SecurityManagement;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.smgmt.j9.J9SecurityPlugin;


/**
 * @author Rod
 *
 */
public class J9SecurityManager extends MtjExtensionImpl implements
SecurityManagement {

	
	// private variables
	private String storeType = "JKS"; //$NON-NLS-1$
	private String aliaskey = null;
	private String passwrd = null;
	private String keyStoreNameLoc = ""; //$NON-NLS-1$
	private String validity = "365"; //$NON-NLS-1$
	
	private IPreferenceStore securityProviderPrefStore;
	/**
	 * 
	 */
	public J9SecurityManager() {
		super();

		setId(J9SecurityPlugin.getDefault().getBundle().getSymbolicName());
		setVendor(Messages.J9SecurityManager_PluginVendor); 
		setVersion(Messages.J9SecurityManager_PluginVersion); 
		setDescription(Messages.J9SecurityManager_Description); 
		setType(ExtensionType.SECURITY_MANAGEMENT_LITERAL);
		securityProviderPrefStore = J9SecurityPlugin.getDefault().getPreferenceStore();
		
	}

	public String [] openKeyStore(String keyStore, String storePass, IProgressMonitor monitor) throws MtjException {
		monitor.beginTask(Messages.J9SecurityManager_Opening_keystore, 100); 
		
		
		String[] cmdArgs = generateOpenKeyStoreCmd(keyStore,storePass);
		Process p = runSecurityCmd(cmdArgs);
		
		BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));

		String cmdOutput;
		//ArrayList aliases = new ArrayList();
		List<String> aliases = new ArrayList<String>();

		monitor.worked(50);
		try {
			while ((cmdOutput=cmdOutputStream.readLine()) != null) {
						
				if (cmdOutput.toLowerCase().indexOf("error")>=0) {  //$NON-NLS-1$
					//MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Error", cmdOutput);  //$NON-NLS-1$
					//return null;
					monitor.done();
					if (cmdOutput.toLowerCase().indexOf("Keystore password should have at least 6 characters")>=0) {  //$NON-NLS-1$
						throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.SECURITY_MALFORMED_PASSWORD) + cmdOutput);
					} else if (cmdOutput.toLowerCase().indexOf("Check the file path and password.")>=0) {  //$NON-NLS-1$
						throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.SECURITY_BAD_KEYSTORE_OR_PASSWORD) + cmdOutput);
					} 
					else {
						throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY) + " " + cmdOutput); //$NON-NLS-1$
					}
					

				} else if (cmdOutput.indexOf(",")>=0) { //$NON-NLS-1$
					StringTokenizer strtok = new StringTokenizer(cmdOutput, ".,"); //$NON-NLS-1$
					aliases.add(strtok.nextToken());
				}
			}
		} catch (IOException ee) {
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY), ee);
		}
		monitor.worked(100);
		monitor.done();
		return (String[])aliases.toArray(new String[aliases.size()]);
	}

	public String getStoreType() throws MtjException{
		return storeType;
	}

	public String getAliaskey() throws MtjException{
		return aliaskey;
	}

	public String getPassWrd() throws MtjException{
		return passwrd;
	}

	public String getKeyStoreNameLoc() throws MtjException{
		return keyStoreNameLoc;
	}

	public String getValidity()throws MtjException {
		return validity;
	}

	public void setStoreType(String storeType) throws MtjException{
		this.storeType = storeType;
	}

	public void setAliaskey(String aliasKey) throws MtjException{
		this.aliaskey = aliasKey;
	}

	public void setPassWrd(String passWrd) throws MtjException{
		this.passwrd = passWrd;
	}

	public void setKeyStoreNameLoc(String keyStoreNameLoc) throws MtjException{
		this.keyStoreNameLoc = keyStoreNameLoc;
	}

	public void setValidity(String validity) throws MtjException{
		this.validity = validity;
	}

	public void setValues(String loc, String alias, String psswd, String strtype) throws MtjException {
		
		storeType 			= strtype;
		aliaskey 			= alias;
		passwrd 			= psswd;
	    keyStoreNameLoc 	= loc;	
		
	}

	
	/*
	 * Generating the command to Open a Key Store and display its contents.
	 * 
	 */
	private String[] generateOpenKeyStoreCmd( String keyStore, String storePasswd) throws MtjException {
		
		String[] openKeyStoreCmdArgs = {getSecurityManagementTool(),
										getConsoleEncoding(),
										J9SecurityManagerConstants.LIST,
										J9SecurityManagerConstants.STORETYPE,storeType,
										J9SecurityManagerConstants.KEYSTORE,keyStore,
										J9SecurityManagerConstants.STOREPASS,storePasswd};
		return openKeyStoreCmdArgs;
	}
    /*
	 * Get the Security Management tool from pref store location.
	 * 
	 */
	private final String getSecurityManagementTool() throws MtjException {
	String securityToolLocation = getToolLocation(null);
		
		if (securityToolLocation == null ||
			securityToolLocation.length() <= 0 ||
			securityToolLocation.equals(Messages.J9SecurityManager_Specify_directory_here)	 
			){
				String message = MessageFormat.format (Messages.J9SecurityManager_getSecurityManagerException, 
						new Object[] {getId(), Messages.J9SecurityManager_Tool_not_configured_correctly, Messages.J9SecurityManager_Using_Security_management_features});
				throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.SECURITY_MANAGER_NOT_CONFIGURED) + "\n" +  //$NON-NLS-1$
						message);
			}
		
		StringBuffer buffer = new StringBuffer("\"");
		buffer.append(securityToolLocation)
		.append(File.separator)
		.append("bin") //$NON-NLS-1$						
		.append(File.separator)
		.append("keytool.exe") //$NON-NLS-1$
		.append("\"");
			
		return buffer.toString();
	}
	private static String getConsoleEncoding ()
	{
		return  "-J-Dconsole.encoding=" + System.getProperty("file.encoding"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	private Process runSecurityCmd (String[] cmd) throws MtjException {
		
		Process p = null;

		try {p =	Runtime.getRuntime().exec(cmd, new String[] {});} 
		catch (IOException e){
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY));	
		}
		
		if (p == null)
		 {
			StringBuffer str = new StringBuffer(""); //$NON-NLS-1$
			
			for (int i = 0; i < cmd.length; i++)
			{
				str.append(" " + cmd[i]); //$NON-NLS-1$
			}
		
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY) + Messages.J9SecurityManager_Could_not_execute + " [" + str +"]");    //$NON-NLS-1$ //$NON-NLS-2$
		}
		
		return p;	
	}

	/**
	 * isKeyStoreSelected - user of this class will specify the keystore name/location 
	 * to manage.
	 * @return true if a keystore name and location was set during this session.
	 */
	public boolean isKeyStoreSelected () throws MtjException {
		
		if ((keyStoreNameLoc == null) || (keyStoreNameLoc.length()<= 0))
			return false;
		
		return true;
	}
	
	/*
	 * 
	 * 
	 */
	public boolean importSignedCert( String certFile, IProgressMonitor monitor) throws MtjException {
		boolean cmdSuccessful = true;
		String[] cmdArgs = generateImportSignedCertCmd( certFile );
		Process p = runSecurityCmd(cmdArgs);
		
		BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
			
		String cmdOutput;
		try {
			while ((cmdOutput=cmdOutputStream.readLine()) != null) {
						
				if (cmdOutput.indexOf("error")>=0) {  //$NON-NLS-1$
					//MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Error", cmdOutput);  //$NON-NLS-1$
					//cmdSuccessful = false;
					throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY) + cmdOutput);
				}
			}
		} catch (IOException ee) {
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY), ee);
		}
		return cmdSuccessful;
	}
	
	/*
	 * 
	 * 
	 */
	private String[] generateImportSignedCertCmd( String certFile ) throws MtjException {

		String[] importSignedCertCmdArgs = {getSecurityManagementTool(),
					 getConsoleEncoding(),
					 J9SecurityManagerConstants.IMPORT_CERT,
					 J9SecurityManagerConstants.NOPROMPT,
					 J9SecurityManagerConstants.ALIAS,aliaskey,
					 J9SecurityManagerConstants.KEYPASS,passwrd,
					 J9SecurityManagerConstants.FILE,certFile,
					 J9SecurityManagerConstants.STORETYPE,storeType,
					 J9SecurityManagerConstants.KEYSTORE,keyStoreNameLoc,
					 J9SecurityManagerConstants.STOREPASS,passwrd};
					
		return importSignedCertCmdArgs;
	}

	public boolean generateCSR( String certFile, IProgressMonitor monitor) throws MtjException{
		boolean cmdSuccessful = true;
		String[] cmdArgs = generateGenerateCSRCmd( certFile);
		Process p = runSecurityCmd(cmdArgs);

		BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
		
		String cmdOutput;
		try {
			while ((cmdOutput=cmdOutputStream.readLine()) != null) {
						
				if (cmdOutput.toLowerCase().indexOf("error")>=0) {  //$NON-NLS-1$
					//MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Error", cmdOutput); //$NON-NLS-1$
					//cmdSuccessful = false;
					throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY) + " " + cmdOutput); //$NON-NLS-1$
				}
			}
		} catch (IOException ee) {
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY), ee);
		}
		return cmdSuccessful;

	}
	
	/*
	 * 
	 * 
	 */
	private String[] generateGenerateCSRCmd( String certFile ) throws MtjException {

		String[] generateCSRCmdArgs = {getSecurityManagementTool(),
					 getConsoleEncoding(),
					 J9SecurityManagerConstants.GENERATE_CSR,
					 J9SecurityManagerConstants.ALIAS,aliaskey,
					 J9SecurityManagerConstants.FILE,certFile,
					 J9SecurityManagerConstants.STORETYPE,storeType,
					 J9SecurityManagerConstants.KEYSTORE,keyStoreNameLoc,
					 J9SecurityManagerConstants.STOREPASS, passwrd};
					
		return generateCSRCmdArgs;
	}
	
	/*
	 * 
	 * 
	 */
	public boolean deleteKey(IProgressMonitor monitor ) throws MtjException{
		
		boolean cmdSuccessful = true;
		String[] cmdArgs = generateDeleteKeyCmd( );
		Process p = runSecurityCmd(cmdArgs);
		
		BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
		
		String cmdOutput;
		try {
			while ((cmdOutput=cmdOutputStream.readLine()) != null) {
						
				if (cmdOutput.toLowerCase().indexOf("error")>=0) {  //$NON-NLS-1$
					//MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Error", cmdOutput); //$NON-NLS-1$
					//cmdSuccessful = false;
					throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY) + " " + cmdOutput); //$NON-NLS-1$
				}
			}
		} catch (IOException ee) {
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY), ee);
		}
		return cmdSuccessful;

	}
	
	/*
	 * 
	 * 
	 */
	private String[] generateDeleteKeyCmd( ) throws MtjException {

		String[] deleteKeyCmdArgs = {getSecurityManagementTool(),
									 getConsoleEncoding(),
									 J9SecurityManagerConstants.DELETE_KEY,
									 J9SecurityManagerConstants.ALIAS,aliaskey,
									 J9SecurityManagerConstants.STORETYPE,storeType,
									 J9SecurityManagerConstants.KEYSTORE,keyStoreNameLoc,
									 J9SecurityManagerConstants.STOREPASS,passwrd};
					
		return deleteKeyCmdArgs;
	}
	
	public boolean changeStorePassword(String newStorePass, String storePass, IProgressMonitor monitor ) throws MtjException{
		
		boolean cmdSuccessful = true;
		String[] cmdArgs = generateChangeStorePasswordCmd(newStorePass, storePass);
		Process p = runSecurityCmd(cmdArgs);
		BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
		
		String cmdOutput;
		try {
			while ((cmdOutput=cmdOutputStream.readLine()) != null) {
						
				if (cmdOutput.toLowerCase().indexOf("error")>=0) {  //$NON-NLS-1$
					//MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),"Error", cmdOutput);  //$NON-NLS-1$
					//cmdSuccessful = false;
					throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY) + " " + cmdOutput); //$NON-NLS-1$
				}
			}
		} catch (IOException ee) {
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY), ee);
		}
		return cmdSuccessful;
	}
	
	/*
	 * Generating the command to change the key store password.
	 * 
	 */
	private String[] generateChangeStorePasswordCmd(String newStorePass, String storePasswd) throws MtjException {
		
		String[] changeStorePasswordCmdArgs = { getSecurityManagementTool(),
												getConsoleEncoding(),
												J9SecurityManagerConstants.CHANGE_STORE_PASSWD,
												J9SecurityManagerConstants.NEWSTOREPASS,newStorePass,
												J9SecurityManagerConstants.STORETYPE,storeType,
												J9SecurityManagerConstants.KEYSTORE,keyStoreNameLoc,
												J9SecurityManagerConstants.STOREPASS,storePasswd};		
		
		return changeStorePasswordCmdArgs;
	}

	public boolean createNewKey(String alias, String commonName, String orgUnit, String orgName, String localityName, String stateName, String country, IProgressMonitor monitor) throws MtjException{
		
		monitor.beginTask(Messages.J9SecurityManager_Creating_key_alias, 100); 
		
		boolean cmdSuccessful = true;
		String Dname = generateDname(commonName, orgUnit, orgName, localityName, stateName, country);
		String[] cmdArgs = generateNewKeyCmd(alias, Dname, "RSA", "SHA1withRSA" ); //$NON-NLS-1$ //$NON-NLS-2$
		Process p = runSecurityCmd(cmdArgs);
		
		monitor.worked(10);
			
		BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
//		BufferedReader cmdErrorStream = new BufferedReader(new InputStreamReader(p.getErrorStream()));
//		BufferedReader cmdinputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
//		
//		try {
//			if (cmdErrorStream.ready()){
//				System.out.println("error read:" + cmdErrorStream.read());
//			}else if (cmdinputStream.ready()){
//				System.out.println("input read:" + cmdinputStream.read());
//				
//			}
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		int i = 0;
//		while (true){
//			i++;
//			
//	   try {	
//		  if( p.exitValue() == 0){
//			  break;
//		  }
//	   } catch (IllegalThreadStateException e) {
//		  
//		   e.printStackTrace();
//		   try {
//			Thread.sleep(10000);
//		} catch (InterruptedException e1) {
//			System.out.println("coudlnt' sleep");
//			e1.printStackTrace();
//		}
//		System.out.println("P is still running");
//		if (i > 5){ p.destroy();
//		break;
//		}
//	   }
//	}
//		 try {
//			p.wait(100000);
//		} catch (InterruptedException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
		String cmdOutput;
		try {
			//if (cmdOutputStream.ready()){
				if ((cmdOutput=cmdOutputStream.readLine()) != null) {
					monitor.worked(40);
					if (cmdOutput.toLowerCase().indexOf("error")>=0) {  //$NON-NLS-1$
						monitor.done();
						if (cmdOutput.toLowerCase().indexOf("keystore contains the given alias")>=0) {  //$NON-NLS-1$
							throw new MtjException(cmdOutput);
						}
	
						throw new MtjException(cmdOutput);
					}
				}
			//}
		} catch (IOException ee) {
			throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY), ee);
		}

		monitor.worked(100);
		monitor.done();
		return cmdSuccessful;

	}
	
	/*
	 * 
	 * 
	 */
	private String[] generateNewKeyCmd(String alias, String dname, String keyAlg, String sigAlg) throws MtjException {
		
		String[] newKeyCmdArgs = {
				getSecurityManagementTool(), 
				getConsoleEncoding(),
				J9SecurityManagerConstants.GENERATE_KEY,
				"-v",
				J9SecurityManagerConstants.ALIAS,alias,
				J9SecurityManagerConstants.DNAME,dname,
				J9SecurityManagerConstants.KEYPASS,passwrd,
				J9SecurityManagerConstants.STORETYPE,storeType,
				J9SecurityManagerConstants.KEYALG,keyAlg,
				J9SecurityManagerConstants.SIGALG,sigAlg,
				J9SecurityManagerConstants.KEYSTORE,keyStoreNameLoc,
				J9SecurityManagerConstants.STOREPASS,passwrd,
				J9SecurityManagerConstants.VALIDITY,validity
				};
			
		return newKeyCmdArgs;
	}
	
	/*
	 * Generating the Distinguished Name (dname) string using the given user input. 
	 * 
	 */
	public String generateDname(String commonName, String orgUnit, String orgName, String localityName, String stateName, String country) {
		String Dname = J9SecurityManagerConstants.QUOTE + J9SecurityManagerConstants.COMMON_NAME_PREFIX + commonName + J9SecurityManagerConstants.COMMA_AND_SPACE
						+ J9SecurityManagerConstants.ORGANIZATION_UNIT_PREFIX + orgUnit + J9SecurityManagerConstants.COMMA_AND_SPACE
						+ J9SecurityManagerConstants.ORGANIZATION_NAME_PREFIX + orgName + J9SecurityManagerConstants.COMMA_AND_SPACE
						+ J9SecurityManagerConstants.LOCALITY_NAME_PREFIX + localityName + J9SecurityManagerConstants.COMMA_AND_SPACE
						+ J9SecurityManagerConstants.STATE_NAME_PREFIX + stateName + J9SecurityManagerConstants.COMMA_AND_SPACE
						+ J9SecurityManagerConstants.COUNTRY_PREFIX + country + J9SecurityManagerConstants.QUOTE;
		return Dname;
	}
	/**
	 * getCertificateInfo - Get the certificates associated with the alias key/keystore
	 * @param alias - alias key
	 * @param storePass
	 * @return
	 */ 
	public String getCertificateInfo( IProgressMonitor monitor ) throws MtjException{
		
		String certInfo = ""; //$NON-NLS-1$
		
		if ((aliaskey != null) && (aliaskey.length() > 0)) {
			
			try {
				String[] cmdArgs = generateDisplayCertifcates( );		
				Process p = runSecurityCmd(cmdArgs);
				BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
				
				String cmdOutput;
			
				while ((cmdOutput=cmdOutputStream.readLine()) != null) {
						
					if (cmdOutput.toLowerCase().indexOf("error")>=0) {  //$NON-NLS-1$
					// MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Error", cmdOutput);  //$NON-NLS-1$
					 //return ""; //$NON-NLS-1$
						throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY) + " " + cmdOutput); //$NON-NLS-1$
					} else if (cmdOutput.length() >= 0) {
						certInfo = certInfo + cmdOutput;					
					  }
				}
						
			} catch (IOException ee) {
				certInfo = ""; //$NON-NLS-1$
				throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY), ee);
			}
			 catch(Exception e){
			 	certInfo = ""; //$NON-NLS-1$
			 	throw new MtjException(MtjCoreErrors.getErrorMessage(MtjCoreErrors.ERROR_BASE_SECURITY), e);
			 }
		}//if aliaskey
		
		return certInfo;
	}
	
	/**
	 * generateDisplayCertifcates - Command to display all certificates for a given key (alias)
	 * @param alias - alias key for which the certificate info is being requested.
	 * @param storePasswd - password used to open keystore
	 * @return
	 * @throws MtjException 
	 */
	private String[] generateDisplayCertifcates( ) throws MtjException {
		
		String[] listCertificateCmdArgs = 
					{	getSecurityManagementTool(),
						getConsoleEncoding(),
						J9SecurityManagerConstants.LIST,
						J9SecurityManagerConstants.ALIAS,aliaskey,									
						J9SecurityManagerConstants.STORETYPE,storeType,					
						J9SecurityManagerConstants.KEYSTORE,keyStoreNameLoc,
						J9SecurityManagerConstants.STOREPASS,passwrd};
			
		return listCertificateCmdArgs;
	}


	public String getToolLocation(IProgressMonitor monitor) throws MtjException {
		return securityProviderPrefStore.getString(J9SecurityManagerConstants.SECURITY_TOOL_LOCATION);
	}

	public void storeToolLocation(String loc, IProgressMonitor monitor) throws MtjException {
		securityProviderPrefStore.setValue(J9SecurityManagerConstants.SECURITY_TOOL_LOCATION, loc);
	}

	public void resetValues() throws MtjException {
		// TODO Auto-generated method stub		
	}

}
