/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.toolkit;

import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.exception.MtjException;

/** Interface for supporting the impport of DevicePlatform objects. */
public interface ToolkitSupport {

	/**
	 * Method returns DevicePlatformImporter of the owner
	 * 
	 * @return
	 */
	public DevicePlatformImporter getDevicePlatformImporter();
	
	/**
	 * Methods set DevicePlatforms to the owner.
	 * 
	 * @param dps
	 * @throws MtjException
	 */
	public void setDevicePlatforms(DevicePlatform[] dps) throws MtjException;
	
	/**
	 * Method returns owner's DevicePlatforms.
	 * 
	 * @return
	 * @throws MtjException
	 */
	public DevicePlatform[] getDevicePlatforms() throws MtjException;
}
