/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM - initial API and implementation
 *******************************************************************************/
package org.eclipse.mtj.extension.sp.ui.utils;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.PersistentStoreProvider;
import org.eclipse.mtj.api.extension.SigningProvider;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.exception.MtjNotFoundException;

public class SpUtils {

	public static Object getSigningProviders(){
		
		MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.SIGNING_PROVIDER_LITERAL, null, null);
		SigningProvider [] spList = new SigningProvider[list.length];
				
		for(int i = 0; i < list.length; i++){
			spList[i] = (SigningProvider)list[i];
		}
		
		return spList;
	}
	
	public static Object getSigningProvidersList() throws MtjException{

		MtjExtension[] installedSPPINList = MtjServices.getInstance().getImplementations(ExtensionType.SIGNING_PROVIDER_LITERAL, null, null);
		SigningProvider [] splist = new SigningProvider[installedSPPINList.length];

		for (int i = 0; i < installedSPPINList.length; i++){
			splist[i] = (SigningProvider)installedSPPINList[i];
		}
		PersistentStoreProvider pstore = (PersistentStoreProvider) MtjServices
				.getInstance().getImplementations(
						ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, 
						null, null)[0];
		
		EList signingProviders = null;
		try {
		signingProviders = (EList) pstore.get(
				PersistentStoreProvider.DATA_TYPE_EMF, "signingProviders", //$NON-NLS-1$
				"org.eclipse.mtj.extension.sp.ui", "MtjSigningProviders"); //$NON-NLS-1$ //$NON-NLS-2$
		} catch (MtjNotFoundException e) {
		//only throw this if smlist is empty
			if (splist.length <= 0) {
				throw e;
			}
		}
		//If we got a list from the permanent storage provider,
		//compare it to the installed plug-ins list and
		//set active flags
		if (signingProviders != null) {
			for (int i = 0; i < signingProviders.size(); i++) {
				for (int j = 0; j < splist.length; j++){
					if(splist[j].getId().equals(((MtjExtension)signingProviders.get(i)).getId()))
					{
						splist[j].setActive(((MtjExtension)signingProviders.get(i)).isActive());
					}
				}
			}
		}
		
		return splist;
	}
	
	public static boolean storeSigningProviders(Object signingproviders){
		
		boolean storeOk = true;
		
		PersistentStoreProvider psp = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
		
		EList providers = null;
		
		if(signingproviders instanceof SigningProvider[]){
			
			providers = new BasicEList();

			
			SigningProvider[] signingProviders = (SigningProvider[])signingproviders;
			
			for(int i = 0; i < signingProviders.length; i++){
				
				providers.add(signingProviders[i]);
			}
		}
		else if(signingproviders instanceof EList){
			providers = (EList)signingproviders;
		}
		
		try {
			psp.store(providers, PersistentStoreProvider.DATA_TYPE_EMF,
					 "signingProviders", //$NON-NLS-1$
						"org.eclipse.mtj.extension.sp.ui", "MtjSigningProviders");  //$NON-NLS-1$//$NON-NLS-2$

		} catch (MtjException e) {
			storeOk = false;
		}
		
		return storeOk;
		
	}
}
