/**
 * Copyright (c) 2003-2006 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.extension.devide.config;

import org.eclipse.mtj.core.version.Version;

/**
 * Tracks a specification of a particular library.  Includes
 * the name of the specification, an identifier and the 
 * version of that specification.
 * <p />
 * Copyright (c) 2003-2006 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:51:15 $
 * <br>
 * @author Craig Setera
 */
public class LibrarySpecification {
	private String identifier;
	private String name;
	private Version version;
	
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * @return Returns the version.
	 */
	public Version getVersion() {
		return version;
	}
	
	/**
	 * @param version The version to set.
	 */
	public void setVersion(Version version) {
		this.version = version;
	}

	/**
	 * @return Returns the identifier.
	 */
	public String getIdentifier() {
		return identifier;
	}

	/**
	 * @param identifier The identifier to set.
	 */
	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}
}
