/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 
package org.eclipse.mtj.extension.devide.launching;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.SourceLookupTab;

/**
 * Tab group implementation for the launch of the Mtj application
 */
public class ToolkitEmulatorTabGroup extends AbstractLaunchConfigurationTabGroup {
	/**
	 * @see org.eclipse.debug.ui.ILaunchConfigurationTabGroup#createTabs(org.eclipse.debug.ui.ILaunchConfigurationDialog, java.lang.String)
	 */
	public void createTabs(ILaunchConfigurationDialog dialog, String mode) {

		// Set up the tabs to communicate with each other
		JavaTab javaTab = new JavaTab();
		DeviceTab deviceTab = new DeviceTab(javaTab);
		javaTab.setDeviceTab(deviceTab);

		ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[] {
		    javaTab,
			deviceTab,
			// new JavaArgumentsTab(),
			// new JavaClasspathTab(),
			// new JavaJRETab(),
			new SourceLookupTab(),
			new CommonTab()
		};
		
		for (int i = 0; i < tabs.length; i++) {
			tabs[i].setLaunchConfigurationDialog(dialog);
		}
		
		setTabs(tabs);
	}
}
