/*******************************************************************************
* Copyright (c) 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
* Contributors:
*IBM - initial API and implementation
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.midletsuite;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.jad.util.JadFileDescriptor;
import org.eclipse.mtj.jad.util.MIDletDescriptor;
import org.eclipse.mtj.jad.util.SynchronizeManifestFileToJad;

public class MidletSuitePackagingWizard extends Wizard {
	
	private IStructuredSelection selected;
	IFile jadIFile;
	JadFileDescriptor jadFile;
	MIDletDescriptor manifestFile; 
	IProject project;
	
	public MidletSuitePackagingWizard(IStructuredSelection selected) {
		this.selected = selected;
		
		Object ob = selected.getFirstElement();
		if (ob instanceof IProject)
			project = (IProject) ob;
		if (ob instanceof IFile)
		{
			IFile jadOrManifestFile = (IFile) ob;
			project = jadOrManifestFile.getProject();
		}

		jadIFile = project.getFile(project.getName() + ".jad"); //$NON-NLS-1$
		try {
			if (!jadIFile.exists())  // This will not try to load an existing file value
				jadFile = JadFileDescriptor.getDescriptor(project);
			else
			{
				jadFile = JadFileDescriptor.getDescriptor(jadIFile);
				jadFile.setupMIDlets();
			}
		} catch (CoreException e) {
			// TODO 
			e.printStackTrace();
		} catch (IOException e) {
			// TODO 
			e.printStackTrace();
		}
	}
	
	public IStructuredSelection getSelected() {
		return selected;
	}
	
	public void addPages() {
		MidletSuitePackagingWizardPage page = new MidletSuitePackagingWizardPage("page1", jadFile, project); //$NON-NLS-1$
		addPage(page);
	}

	public boolean performFinish() {
		try 
		{
			IProgressMonitor pm = new NullProgressMonitor();
			jadFile.serialize(jadIFile, pm);
			SynchronizeManifestFileToJad info = new SynchronizeManifestFileToJad (jadIFile);
			info.run(pm);
//			if (!J2MEMidpNature.hasJ2MEMidpNature(project))
//			{
//				String[] naturesToAdd = {J2MEMidpNature.getNatureIdName()};
//				ProjectCreationAction.addNatures(project, naturesToAdd,  pm);
//			}
		}
		catch (FileNotFoundException e1) {
			// TODO 
			e1.printStackTrace();
		} catch (IOException e1) {
			// TODO 
			e1.printStackTrace();
		}  catch (CoreException e) {
			// TODO 
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO 
			e.printStackTrace();
		} catch (InterruptedException e) {
			// TODO 
			e.printStackTrace();
		}
		return true;
	}
}
