/*******************************************************************************
* Copyright (c) 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
* Contributors:
*IBM - initial API and implementation
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.midletsuite;

import org.eclipse.core.resources.IProject;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.jad.util.JadFileDescriptor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/**
 * MidletSuiteSectionRequired.java 2006 Mar 1, 2006 4:08:21 PM @author khorowit
 *
 */
public class MidletSuiteSectionRequired extends MidletSuiteSectionTemplate {

	JadFileDescriptor jadFile;
	FormToolkit formToolkit;
	
	Text midletJarName;
	Text midletSuiteName;
	Text midletVersion;
	Text midletVendor;
	CCombo configurationName;
	CCombo profileName;
	
	String projectName = null;
	
	/**
	 * A constructor for MidletSuiteSectionRequired.java
	 * @param parent
	 * @param toolkit
	 * @param style
	 */
	public MidletSuiteSectionRequired(JadFileDescriptor jadFileDescriptor, Composite parent, FormToolkit toolkit,
			int style) {
		super(parent, toolkit, style);
		jadFile = jadFileDescriptor;
		formToolkit = toolkit;
		
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);

		Section section = getSection();
		section.setLayoutData(gd);
		
		section.setText(Messages.MidletSuiteSectionRequired__Required_Data);
		section.setDescription(Messages.MidletSuiteSectionRequired_Configure_the_required_project_data);
		
		Composite sectionClient = toolkit.createComposite(section);

		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		
		
		midletJarName = FormToolkitTemplate.createTextEntry (Messages.MidletSuiteSectionRequired_Midlet_Jar_Name, jadFile.getProperty(JadFileDescriptor.JAR_URL), formToolkit, sectionClient);
		jadFile.setProperty (JadFileDescriptor.JAR_URL, midletJarName.getText());
		midletJarName.addModifyListener(new ModifyListener () {
			public void modifyText(ModifyEvent e) {
				jadFile.setProperty (JadFileDescriptor.JAR_URL, midletJarName.getText());
			}
		});
		
		midletSuiteName = FormToolkitTemplate.createTextEntry (Messages.MidletSuiteSectionRequired_Midlet_Suite_Name, jadFile.getProperty(JadFileDescriptor.NAME), formToolkit, sectionClient);
		jadFile.setProperty (JadFileDescriptor.NAME, midletSuiteName.getText());
		midletSuiteName.addModifyListener(new ModifyListener () {
			public void modifyText(ModifyEvent e) {
				jadFile.setProperty(JadFileDescriptor.NAME, midletSuiteName.getText());	
			}
		});

		midletVendor = FormToolkitTemplate.createTextEntry (Messages.MidletSuiteSectionRequired_Vendor_Name, jadFile.getProperty(JadFileDescriptor.VENDOR), formToolkit, sectionClient);
		jadFile.setProperty (JadFileDescriptor.VENDOR, midletVendor.getText());
		midletVendor.addModifyListener(new ModifyListener () {
			public void modifyText(ModifyEvent e) {
				jadFile.setProperty(JadFileDescriptor.VENDOR, midletVendor.getText());	
			}
		});

		midletVersion = FormToolkitTemplate.createTextEntry (Messages.MidletSuiteSectionRequired_Version, jadFile.getProperty(JadFileDescriptor.VERSION), formToolkit, sectionClient);
		jadFile.setProperty (JadFileDescriptor.VERSION, midletVersion.getText());
		midletVersion.addModifyListener(new ModifyListener () {
			public void modifyText(ModifyEvent e) {
				jadFile.setProperty(JadFileDescriptor.VERSION, midletVersion.getText());	
			}
		});
		
		String existingProfileValue = jadFile.getProperty (JadFileDescriptor.PROFILE_NAME);
		if (existingProfileValue != null && existingProfileValue.compareTo("") != 0) //$NON-NLS-1$
			existingProfileValue = JadFileDescriptor.MIDP_DEFAULT_VALUE;
		profileName = FormToolkitTemplate.createComboEntry (Messages.MidletSuiteSectionRequired_Profile, existingProfileValue, JadFileDescriptor.MIDP_VALID_VALUES, formToolkit, sectionClient);
		jadFile.setProperty (JadFileDescriptor.PROFILE_NAME, profileName.getText());		
		profileName.addSelectionListener(new SelectionListener () {
			public void widgetSelected(SelectionEvent e) {
				jadFile.setProperty(JadFileDescriptor.PROFILE_NAME, profileName.getText());	
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				jadFile.setProperty(JadFileDescriptor.PROFILE_NAME, profileName.getText());
			}
		});
		profileName.setData(FormToolkit.KEY_DRAW_BORDER, FormToolkit.TREE_BORDER);


		String existingConfigurationValue = jadFile.getProperty (JadFileDescriptor.CONFIGURATION_NAME);
		if (existingConfigurationValue != null && existingConfigurationValue.compareTo("") != 0) //$NON-NLS-1$
			existingConfigurationValue = JadFileDescriptor.CLDC_DEFAULT_VALUE;
		configurationName = FormToolkitTemplate.createComboEntry (Messages.MidletSuiteSectionRequired_Configuration, existingConfigurationValue, JadFileDescriptor.CLDC_VALID_VALUES, formToolkit, sectionClient);
		jadFile.setProperty (JadFileDescriptor.CONFIGURATION_NAME, configurationName.getText());
		configurationName.addSelectionListener(new SelectionListener () {
			public void widgetSelected(SelectionEvent e) {
				jadFile.setProperty (JadFileDescriptor.CONFIGURATION_NAME, configurationName.getText());
			}
			public void widgetDefaultSelected(SelectionEvent e) {
				jadFile.setProperty (JadFileDescriptor.CONFIGURATION_NAME, configurationName.getText());
			}
		});
		configurationName.setData(FormToolkit.KEY_DRAW_BORDER, FormToolkit.TREE_BORDER);

			
		toolkit.paintBordersFor(sectionClient);
		sectionClient.setLayout(layout);

		section.setClient(sectionClient);
		
	}

	public void initializeData (IProject project)
	{
		jadFile = JadFileDescriptor.getDescriptor(project);
		
		midletJarName.setText(jadFile.getProperty(JadFileDescriptor.JAR_URL));

		midletSuiteName.setText (jadFile.getProperty(JadFileDescriptor.NAME));

		midletVendor.setText(jadFile.getProperty(JadFileDescriptor.VENDOR));

		midletVersion.setText(jadFile.getProperty (JadFileDescriptor.VERSION));

		String existingProfileValue = jadFile.getProperty (JadFileDescriptor.PROFILE_NAME);
		if (existingProfileValue == null)
			existingProfileValue = JadFileDescriptor.MIDP_DEFAULT_VALUE;
		else if (existingProfileValue.compareTo("") == 0) //$NON-NLS-1$
			existingProfileValue = JadFileDescriptor.MIDP_DEFAULT_VALUE;
		profileName.setText(existingProfileValue);
		jadFile.setProperty (JadFileDescriptor.PROFILE_NAME, profileName.getText());		

		String existingConfigurationValue = jadFile.getProperty (JadFileDescriptor.CONFIGURATION_NAME);
		if (existingConfigurationValue == null)
			existingConfigurationValue = JadFileDescriptor.CLDC_DEFAULT_VALUE;
		else if (existingConfigurationValue.compareTo("") == 0) //$NON-NLS-1$
			existingConfigurationValue = JadFileDescriptor.CLDC_DEFAULT_VALUE;
		configurationName.setText(existingConfigurationValue);
		jadFile.setProperty (JadFileDescriptor.CONFIGURATION_NAME, configurationName.getText());

	}
	public void initializeData (String projectName)
	{
		if (this.projectName == null)
			this.projectName = projectName;
		else if (this.projectName.compareTo (projectName) == 0) // Don't reinitialize if project name is set to the same value
			return;
		
		midletJarName.setText(projectName + ".jar"); //$NON-NLS-1$
		jadFile.setProperty (JadFileDescriptor.JAR_URL, midletJarName.getText());

		midletSuiteName.setText (projectName + Messages.MidletSuiteSectionRequired_Midlet_Suite);
		jadFile.setProperty (JadFileDescriptor.NAME, midletSuiteName.getText());

		midletVendor.setText(Messages.MidletSuiteSectionRequired_EclipseOrg);
		jadFile.setProperty (JadFileDescriptor.VENDOR, midletVendor.getText());

		midletVersion.setText(Messages.MidletSuiteSectionRequired_VersionNumber);
		jadFile.setProperty (JadFileDescriptor.VERSION, midletVersion.getText());

		String existingProfileValue = jadFile.getProperty (JadFileDescriptor.PROFILE_NAME);
		if (existingProfileValue == null)
			existingProfileValue = JadFileDescriptor.MIDP_DEFAULT_VALUE;
		else if (existingProfileValue.compareTo("") == 0) //$NON-NLS-1$
			existingProfileValue = JadFileDescriptor.MIDP_DEFAULT_VALUE;
		profileName.setText(existingProfileValue);
		jadFile.setProperty (JadFileDescriptor.PROFILE_NAME, profileName.getText());		

		String existingConfigurationValue = jadFile.getProperty (JadFileDescriptor.CONFIGURATION_NAME);
		if (existingConfigurationValue == null)
			existingConfigurationValue = JadFileDescriptor.CLDC_DEFAULT_VALUE;
		else if (existingConfigurationValue.compareTo("") == 0) //$NON-NLS-1$
			existingConfigurationValue = JadFileDescriptor.CLDC_DEFAULT_VALUE;
		configurationName.setText(existingConfigurationValue);
		jadFile.setProperty (JadFileDescriptor.CONFIGURATION_NAME, configurationName.getText());

	}
	
	public JadFileDescriptor getJadFile()
	{
		return jadFile;
	}
}
