/*******************************************************************************
* Copyright (c) 1998, 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.core.ui.constants.ProjectCreationConstants;
import org.eclipse.mtj.core.ui.model.ProjectCreationModel;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.devide.ui.wizard.midletsuite.MidletSuitePackagingWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;


public class ProjectCreationAction implements IRunnableWithProgress {
	public static final String NAME = Messages.ProjectCreationAction_Creating_java_project; 
	
	private NewJavaProjectWizardPage fJavaPage;
	//private MTJNewProjectWizardPage fJavaPage;
	private MTJNewProjectSelectLibraryWizardPage fJavaSDKPage;
	private MidletSuitePackagingWizardPage fMidletSuitePage;
	private MTJNewProjectTemplatePage fNewProjTemplatePage;
	private Shell fShell;
	private ProjectCreationModel projectModel;
		
	//public ProjectCreationAction(NewJavaProjectWizardPage javaPage, MTJNewProjectSelectLibraryWizardPage javaSDKPage, MidletSuitePackagingWizardPage fMidletSuitePage, MTJNewProjectTemplatePage templatesPage, ProjectCreationModel projectModel, Shell shell) {
	public ProjectCreationAction(MTJNewProjectWizardPage javaPage, MTJNewProjectSelectLibraryWizardPage javaSDKPage, MidletSuitePackagingWizardPage fMidletSuitePage, MTJNewProjectTemplatePage templatesPage, ProjectCreationModel projectModel, Shell shell) {
		fJavaPage = javaPage;
		fJavaSDKPage = javaSDKPage;
		this.fMidletSuitePage = fMidletSuitePage;
		fShell = shell;
		fNewProjTemplatePage = templatesPage;
		this.projectModel = projectModel;
	}

	/**
	 * @see IRunnableWithProgress#run(IProgressMonitor)
	 */
	public void run(final IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
		runFromWizardpage(pm);
	}

	/**
	 * @param List of natures to add @param nature to.
	 * @return Returns list with nature added if it did not yet contain it.
	 */
	public static String[] updateNatureListWithoutDuplicates(String[] natures, String nature) {
		String[] newNatures = new String[natures.length + 1];
		for (int i = 0; i < natures.length; i++) {
			// Check if project already has nature.
			if (natures[i].equals(nature))
				return natures;
				
			newNatures[i] = natures[i];
		}
		newNatures[natures.length] = nature;
		return newNatures;
	}

	/**
	 * @param project Project to add natures to.
	 * @param naturesToAdd List of natures to add to project
	 */
	public void addNatures(IProject project, String[] naturesToAdd, IProgressMonitor monitor) throws CoreException {
		IProjectDescription description = project.getDescription();
		String[] natures = description.getNatureIds();
		for (int i = 0; i < naturesToAdd.length; i++) {
			natures = updateNatureListWithoutDuplicates(natures, naturesToAdd[i]);
		}
		
		description.setNatureIds(natures);
		project.setDescription(description, IProject.AVOID_NATURE_CONFIG, monitor);
	}
	
	public void runFromWizardpage(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
		final InvocationTargetException[] invException = new InvocationTargetException[1];
		final InterruptedException[] interruptedException = new InterruptedException[1];		
		
		Display display = fShell.getDisplay();
		display.syncExec(new Runnable() {
			public void run() {
				IProgressMonitor pm = new SubProgressMonitor(monitor, 10);
				try {
					fJavaPage.getRunnable().run(new SubProgressMonitor(pm, 8));
					IJavaProject project = fJavaPage.getNewJavaProject();
					// Store the IProject 
					projectModel.setProperty(ProjectCreationConstants.PPC_JPROJECT, project);

					IWorkbenchWindow w = MtjCoreUiPlugin.getActiveWorkbenchWindow();
					BasicNewResourceWizard.selectAndReveal(project.getProject(),w);
					
					// Get the nature to work with
					String nature=(String) projectModel.getProperty(ProjectCreationConstants.PCC_NATURE);
					
					addNatures(project.getProject(), new String[] {nature}, pm);

					TargetDevice[] projectModelData = fJavaSDKPage.getProjectModelData();

					if (fMidletSuitePage != null)
						storeProjectData(project, ProjectType.PROJECT_TYPE_MIDP_LITERAL, projectModelData);
					else
						storeProjectData(project, ProjectType.PROJECT_TYPE_PERSONAL_PROFILE_LITERAL, projectModelData);
						
					
					IMtjProject mtjproject = MtjProject.getMtjProject(project);
					
					if (fMidletSuitePage != null)
					{
						fMidletSuitePage.setProject(project.getProject());
						fMidletSuitePage.doFinish();
					}
			
					if (fNewProjTemplatePage != null){
						fNewProjTemplatePage.setProject(project.getProject());
						if (fJavaPage instanceof MTJNewProjectWizardPage){
							fNewProjTemplatePage.setSrcPath(((MTJNewProjectWizardPage)fJavaPage).getSrcEntry());
						}
						fNewProjTemplatePage.doFinish();
					}
											
					// merge these store projectdata stuff
//					storeProjectPlatformData(mtjproject, projectModelData);
					
					mtjproject.initializeNewProject(pm);
					
					

//					try
//					{
//						IResource resource = (IResource) getElement();
//				        IProject project = resource.getProject();
//						IFile rscFile = project.getFile(key);
//						InputStream inputStream = new ByteArrayInputStream(value.getBytes());
//						// update the resource content
//						if (rscFile.exists()) 
//						{
//							if (rscFile.isReadOnly()) 
//							{
//								// provide opportunity to checkout read-only value file 
//								ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{rscFile}, null);
//							}
//							rscFile.setContents(inputStream, IResource.FORCE, null);
//						} 
//						else 
//						{
//							rscFile.create(inputStream, IResource.FORCE, null);
//						}
//					}
//					catch (CoreException e)
//					{
//						// Output error writing file
//						e.printStackTrace();
//					}

				} catch (MtjException e) {
					invException[0] = new InvocationTargetException(e);
				} catch (CoreException e) {
					invException[0] = new InvocationTargetException(e);
				} catch (InterruptedException e) {
					interruptedException[0] = e;
				} catch (InvocationTargetException e) {
					invException[0] = e;
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} finally {
					pm.done();
				}
			}
		});
		
		if (interruptedException[0] != null)
			throw interruptedException[0];

		if (invException[0] != null)
			throw invException[0];
	}
	
	private void storeProjectData(IJavaProject javaProject, ProjectType projectType, TargetDevice[] targetDevice) throws MtjException {
		Project project = ProjectFactory.eINSTANCE.createProject();
		project.setType(projectType);
		
		if ( targetDevice != null && targetDevice.length > 0 ) {
			project.setDefaultTargetDevice(targetDevice[0]);
		}
		if ( targetDevice != null && targetDevice.length > 1 ) {
			for (int i = 1; i < targetDevice.length; i++) {
				project.getTargetDevices().add(targetDevice[i]);
			}
		}
//		mtjProject.setProjectData(project);
		MtjProject.setProjectData(javaProject, project);

	}
	

}

