/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 

package org.eclipse.mtj.extension.devide.utils;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;

/**
 * Abstract implementation of the IClasspathEntryVisitor.  Provides
 * a default implementation that will return <code>false</code>
 * concerning all resolution and traversal.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:51:21 $
 * <br>
 * @author Craig Setera
 */
public abstract class AbstractClasspathEntryVisitor implements IClasspathEntryVisitor {
	/**
	 * Return a new instance of an object that may be used to run
	 * through the classpath entry tree.  The runner created will
	 * always traverse the tree in a depth-first manner.
	 * 
	 * @return
	 */
	public ClasspathEntryVisitorRunner getRunner() {
		return getRunner(false);
	}

	/**
	 * Return a new instance of an object that may be used to run
	 * through the classpath entry tree.  This method allows the
	 * specification of the breadth versus depth first traversal
	 * order.
	 * 
	 * @param breadthFirst if <code>true</code> use a breadth-first
	 * traversal rather than a depth-first traversal.
	 * @return
	 */
	public ClasspathEntryVisitorRunner getRunner(boolean breadthFirst) {
		return new ClasspathEntryVisitorRunner(breadthFirst);
	}

	public boolean visitContainer(IClasspathEntry entry, IJavaProject javaProject, String containerName, IProgressMonitor monitor) throws CoreException {
		return false;
	}

	public void visitLibraryEntry(IClasspathEntry entry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
	}

	public boolean visitProject(IClasspathEntry entry, IJavaProject javaProject, IJavaProject classpathProject, String natureId, IProgressMonitor monitor) throws CoreException {
		return false;
	}

	public void visitSourceEntry(IClasspathEntry entry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
	}

	public boolean visitVariable(IClasspathEntry entry, IJavaProject javaProject, String variableName, IProgressMonitor monitor) throws CoreException {
		return false;
	}
}