/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dm.ui.preferences;

import org.eclipse.mtj.extension.dm.ui.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DevicePlatformInfoComposite extends Composite {
	private Label nameLabel;
	private Label versionLabel;
	private Label vendorLabel;
	private Label locationLabel;
	
	public Label getNameLabel() {
		return nameLabel;
	}
	
	public Label getVersionLabel() {
		return versionLabel;
	}
	
	public Label getVendorLabel() {
		return vendorLabel;
	}
	
	public Label getLocationLabel() {
		return locationLabel;
	}
	
	public DevicePlatformInfoComposite(Shell parent) {
		super(parent, SWT.NONE);
		setLayout(new GridLayout());
		setLayoutData(new GridData(GridData.FILL_BOTH));
		
		createInfoArea();
		createLocationArea();
	}

	private void createInfoArea(){		
		Group container = createDefaultGroup(this, 2, false);
		container.setText(Messages.DevicePlatformInfoComposite_DevicePlatform);

		createLabel(container, Messages.DevicePlatformInfoComposite_NameLabel);
		nameLabel = createLabel(container, ""); //$NON-NLS-1$
		createLabel(container, Messages.DevicePlatformInfoComposite_VersionLabel);
		versionLabel = createLabel(container, "");		 //$NON-NLS-1$
		createLabel(container, Messages.DevicePlatformInfoComposite_VendorLabel);
		vendorLabel = createLabel(container, "");		 //$NON-NLS-1$
	}

	private void createLocationArea() {
		Group container = createDefaultGroup(this, 2, false);
		container.setText(Messages.DevicePlatformInfoComposite_LocationLabel);
		locationLabel = createLabel(container, "");		 //$NON-NLS-1$
	}
	
	public Text createText(Composite parent, boolean editable){	
		Text text = new Text(parent, SWT.SINGLE | SWT.BORDER);
		text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		text.setEditable(editable);
		
		return text;
	}

	public Label createLabel(Composite parent, String text){	
		Label label = new Label(parent, SWT.NONE);
		label.setText(text);
		label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING));
		
		return label;
	}

	public Group createDefaultGroup(Composite parent, int columns, boolean equalWidth) {
		Group group = new Group(parent, SWT.FILL);
		GridLayout layout = new GridLayout(columns, equalWidth);
		group.setLayout(layout);

		GridData data = new GridData(SWT.FILL, SWT.FILL, true, false);
		group.setLayoutData(data);

		return group;
	}

}
