/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.test;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimesPackage;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.extension.dm.ui.Messages;


public class TestDeviceProfileImpl extends EObjectImpl implements DeviceProfile {
	
	private String name;
	private EList serviceApis;
	private String version;

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.runtimes.DeviceProfile#getServiceApis()
	 */
	public EList getServiceApis() {

		return serviceApis;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.runtimes.DeviceProfile#getName()
	 */
	public String getName() {

		return name;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.runtimes.DeviceProfile#setName(java.lang.String)
	 */
	public void setName(String value) {
		
		name = value;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.runtimes.DeviceProfile#getVersion()
	 */
	public String getVersion() {

		return version;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.runtimes.DeviceProfile#setVersion(java.lang.String)
	 */
	public void setVersion(String value) {

		version = value;

	}
	
	public void setServiceApis(EList value){
		
		if(value == null){
			
			createTestServices();
		}
		serviceApis = value;
	}
	
	public EList getEmptyProfileList() {

		return new EObjectContainmentEList(DeviceProfile.class, this,
				RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_PROFILES);
	}

	private void createTestServices() {

		serviceApis = new EObjectContainmentEList(ServiceApi.class, this,
				RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__SERVICE_APIS);

		ServiceApi service = null;
		for (int i = 0; i < 7; i++) {
			service = new TestServiceApiImpl();
			service.setName(Messages.TestDeviceProfileImpl_ServiceApi + i);
			serviceApis.add(service);
		}
	}
	
	public String toString(){
		
		return name + "-" + version; //$NON-NLS-1$
		
	}

}
