/*******************************************************************************
 * Copyright (c) 2005 Nokia Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.test;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.mtj.api.devices.DevicesPackage;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;

public class TestRuntimePlatformDefinitionImpl extends EObjectImpl implements
		RuntimePlatformDefinition {

	private String myName;

	private EList myDevices;

	private EList myProfiles;

	private EList myConfigs;

	private EList myServices;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDevices()
	 */
	public EList getDevices() {

		return myDevices;
	}

	public void setDevices(EList devices) {

		myDevices = devices;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDeviceProfiles()
	 */
	public EList getDeviceProfiles() {

		return myProfiles;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getServiceApis()
	 */
	public EList getServiceApis() {

		return myServices;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDeviceConfigurations()
	 */
	public EList getDeviceConfigurations() {

		return myConfigs;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getName()
	 */
	public String getName() {

		return myName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#setName(java.lang.String)
	 */
	public void setName(String value) {

		myName = value;
	}

	public void setProfiles(EList value) {

		myProfiles = value;

	}

	public void setConfigurations(EList list) {

		myConfigs = list;
	}

	public void setServices(EList list) {

		myServices = list;
	}

	public EList getEmptyEList() {

		return new EObjectContainmentEList(RuntimePlatformDefinition.class,
				this,
				DevicesPackage.DEVICE_PLATFORM__RUNTIME_PLATFORM_DEFINITIONS);
	}

}
