/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.util;

import java.util.List;
import java.util.Vector;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;


public class ClassLibraryContentProvider implements ITreeContentProvider {
	
	private TreeViewer myViewer;
	private Object myInput;

	public ClassLibraryContentProvider(TreeViewer treeViewer) {
		
		myViewer = treeViewer;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) {
		
		List l = new Vector();
		
		if(parentElement instanceof EList){
			EList list = (EList)parentElement;
			return list.toArray();
		}
		else if(parentElement instanceof RuntimePlatformDefinition){
			RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)parentElement;
			l.addAll(rpd.getDeviceConfigurations());
			l.addAll(rpd.getDeviceProfiles());
			l.addAll(rpd.getServiceApis());
		}
		else if(parentElement instanceof DeviceConfiguration){
			DeviceConfiguration config = (DeviceConfiguration)parentElement;
			l.add(config.getImplementation());
		}
		else if(parentElement instanceof DeviceProfile){
			DeviceProfile profile = (DeviceProfile) parentElement;
			l.addAll(profile.getServiceApis());
		}
		else if(parentElement instanceof ServiceApi){
			ServiceApi sapi = (ServiceApi) parentElement;
			l.add(sapi.getDescription());
			l.add(sapi.getImplementation());
		}
		else if(parentElement instanceof ImplementationRef){
			ImplementationRef ref = (ImplementationRef)parentElement;
			//l.add(ref.getFileRef()); //already in parent
			l.add(ref.getSourceRef());
			l.add(ref.getJavadocRef());
		}
		
		return l.toArray();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object parentElement) {
		
		if(parentElement instanceof EList){
			return true;
		}
		else if(parentElement instanceof RuntimePlatformDefinition){
			return true;
		}
		else if(parentElement instanceof DeviceConfiguration){
			return true;
		}
		else if(parentElement instanceof DeviceProfile){
			return true;
		}
		else if(parentElement instanceof ServiceApi){
			return true;
		}
		else if(parentElement instanceof ImplementationRef){
			
			ImplementationRef ref = (ImplementationRef) parentElement;
			String javadoc = ref.getJavadocRef();
			String source = ref.getSourceRef();
			if(javadoc != null && source != null){
				//check that either one has some content
				if(javadoc.length() > 1 || source.length() > 1){
					return true;
				}
				else{
					return false;
				}
			}
			else{
				return false;
			}
		}
		
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		
		Object[] elements = null;
		
		if(inputElement instanceof EList){
			
			EList eList = (EList)inputElement;
			return eList.toArray();
		}
		
		else if(inputElement instanceof RuntimePlatformDefinition){
			
			RuntimePlatformDefinition rpd = (RuntimePlatformDefinition) inputElement;
			
			elements = new Object[3];
			
			elements[0] = rpd.getDeviceProfiles().get(0);
			elements[1] = rpd.getDeviceConfigurations().get(0);
			elements[2] = (ServiceApi[])rpd.getServiceApis().toArray();
		}
		else if(inputElement instanceof DeviceConfiguration){
			
			DeviceConfiguration config = (DeviceConfiguration) inputElement;
			
			elements = new Object[1];
			elements[0] = config.getImplementation();
		}
		else if(inputElement instanceof DeviceProfile){
			
			DeviceProfile profile = (DeviceProfile) inputElement;
			
			elements = new Object[1];
			elements[0] = (ServiceApi[])profile.getServiceApis().toArray();
			
		}
		else if(inputElement instanceof ServiceApi){
			
			ServiceApi sapi = (ServiceApi) inputElement;
			
			elements = new Object[2];
			elements[0] = sapi.getDescription();
			elements[1] = sapi.getImplementation();
		}
		else if(inputElement instanceof ServiceApi[]){
			
			return (ServiceApi[])inputElement;
		}
		else if(inputElement instanceof ImplementationRef){
			
			ImplementationRef ref = (ImplementationRef)inputElement;
			
			elements = new Object[3];
			elements[0] = ref.getFileRef();
			elements[1] = ref.getSourceRef();
			elements[2] = ref.getJavadocRef();
		}
		else{
			elements = new Object[1];
			
			elements[0] = inputElement;
		}

		return elements;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {

		myViewer = (TreeViewer) viewer;
		myInput = newInput;
	}

}
