/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.util;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.extension.dm.ui.Messages;

public class TargetDeviceLabelProvider extends LabelProvider {
	
	private PreferenceUtils utils;
	
	
	public TargetDeviceLabelProvider(PreferenceUtils utils){
	
		this.utils = utils;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.LabelProvider#getText(java.lang.Object)
	 */
	@Override
	public String getText(Object element) {
		
		StringBuffer sb = new StringBuffer();
		if(element instanceof TargetDevice[]){
			
			TargetDevice device = ((TargetDevice[])element)[0];
			
			sb.append(Messages.TargetDeviceLabelProvider_TargetDevice);
			sb.append(device.getDeviceName());
			sb.append(" (");  //$NON-NLS-1$
			sb.append(device.getDevicePlatformName()); 
			sb.append(")"); //$NON-NLS-1$
		}
		else if(element instanceof TargetDevice){
			
			TargetDevice device = (TargetDevice)element;
			
			sb.append(Messages.TargetDeviceLabelProvider_TargetDevice);
			sb.append(device.getDeviceName());
			sb.append(" (");  //$NON-NLS-1$
			sb.append(device.getDevicePlatformName()); 
			sb.append(")"); //$NON-NLS-1$
		}
		else{
			sb.append(utils.getObjectStyledName(element));
		}
		
		return sb.toString();
	}
	
}
