/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.rpm.model;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.extension.PersistentStoreProvider;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.RuntimesFactory;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.util.MtjEmfUtil;
import org.eclipse.mtj.extension.rpm.Messages;

public class MtjServiceHandler {
	private static final Logger log = Logger.getLogger(MtjServiceHandler.class.getName());

	private DevicePlatform devicePlatform;
	private RuntimePlatform runtimePlatform; 
	private RuntimePlatformDefinition selectedRPD;
	
	public MtjServiceHandler() {}
	
	public RuntimePlatform getRuntimePlatform(RuntimePlatform[] rpa, TargetDevice targetDevice) {
		for(int i = 0; i < rpa.length; i++) {
			Iterator tdl = rpa[i].getTargetDevices().iterator();
			while(tdl.hasNext()) {
				TargetDevice td = (TargetDevice) tdl.next();
				if(td.getDeviceName().equals(targetDevice.getDeviceName())) {
					return rpa[i];
				}
			}			
		}
		
		return null;
	}
	
	public static boolean storeRuntimes(RuntimePlatform[] runtimePlatforms){		
		PersistentStoreProvider psp = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
		EList runtimes = new BasicEList();
		
		for(int i = 0; i < runtimePlatforms.length; i++){		
			runtimes.add((runtimePlatforms)[i]);
		}
		
		try {
			psp.store(runtimes, PersistentStoreProvider.DATA_TYPE_EMF,
					"runtimes", "org.eclipse.mtj.extension.rpm.ui", //$NON-NLS-1$ //$NON-NLS-2$
					"MtjRuntimePlatforms"); //$NON-NLS-1$
			return true;
		} catch (Exception e) {
			return false;
		}
	}

	private static PersistentStoreProvider getPersistentStoreProvider() {
		return (PersistentStoreProvider) MtjServices.getInstance().getImplementations
			(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];		
	} 
	
	private static EList getRuntimePlatforms(PersistentStoreProvider pstore) {
		try {
			return (EList) pstore.get(PersistentStoreProvider.DATA_TYPE_EMF, "runtimes", //$NON-NLS-1$
					"org.eclipse.mtj.extension.rpm.ui", "MtjRuntimePlatforms"); //$NON-NLS-1$ //$NON-NLS-2$
		} catch (Exception e) {
			log.log(Level.WARNING,Messages.MtjServiceHandler_CouldNotProvideRuntimePlatforms,e);
		}		
		return new BasicEList();
	}
	
	public RuntimePlatform[] getRuntimePlatforms() {	
		PersistentStoreProvider pstore = getPersistentStoreProvider();
		EList runtimePlatforms = getRuntimePlatforms(pstore);

		if (runtimePlatforms != null) {
			RuntimePlatform[] rps = new RuntimePlatform[runtimePlatforms.size()];
			for (int i = 0; i < runtimePlatforms.size(); i++) {
				rps[i] = (RuntimePlatform)runtimePlatforms.get(i);
			}
			return rps;
		}
		return new RuntimePlatform[0];
	}
	
	
	public DevicePlatform[] getDevicePlatforms() {
		try {
		DeviceManagement dm = (DeviceManagement) MtjServices.getInstance().getImplementations(
				ExtensionType.DEVICE_MANAGEMENT_LITERAL, null,
				null, true)[0];
			return dm.getDevicePlatforms();
		} catch (Exception e) {
			log.log(Level.WARNING,Messages.MtjServiceHandler_CouldNotProvideDevicePlatforms,e);
		}
		return new DevicePlatform[0];
	}
	
	public DevicePlatform getDevicePlatform(String name) {
		DevicePlatform[] dp = getDevicePlatforms();
		for(int i = 0; i < dp.length; i++) {
			if(dp[i].getName().equals(name)) {
				return dp[i];
			}
		}	
		return null;
	}
	
	public Device getDevice(DevicePlatform devicePlatform, String deviceName) {
		Iterator iterator = devicePlatform.getDevices().iterator();
		while(iterator.hasNext()) {
			Device device = (Device)iterator.next();
			if(device.getName().equals(deviceName))
				return device;
		}
		return null;
	}
	
	public RuntimePlatformDefinition getRuntimePlatformDefinition(String devicePlatformName, String deviceName) {
		try {
			DevicePlatform devicePlatform = getDevicePlatform(devicePlatformName);
			Device device = getDevice(devicePlatform, deviceName);
			if(device != null)
				return (RuntimePlatformDefinition) device.getRuntimePlatformDefinitions().get(0);
		} catch (Exception e) {
			log.log(Level.WARNING,Messages.MtjServiceHandler_CouldNotProvideRuntimePlatformDefinitions,e);
		}
		return null;
	}
	
	public static TargetDevice createTargetDevice(DevicePlatform devicePlatform, RuntimePlatformDefinition rpd, Device device) {
		TargetDevice targetDevice = ProjectFactory.eINSTANCE.createTargetDevice();
		targetDevice.setName(devicePlatform.getName()+" - "+device.getName()); //$NON-NLS-1$
		targetDevice.setDescription(device.getDescription());
		targetDevice.setDeviceName(device.getName());
		targetDevice.setDevicePlatformName(devicePlatform.getName());
		RuntimePlatformDefinition localRPD = MtjEmfUtil.clone(rpd);
		targetDevice.setRuntimePlatform(localRPD);
		return targetDevice;
	}

	// TODO
	public static void setRpdData(RuntimePlatformDefinition rpd, DeviceProfile deviceProfile, DeviceConfiguration deviceConfiguration) {
		/*EList list = rpd.getDeviceProfiles();
		Iterator iterator = list.iterator();
		while(iterator.hasNext()) {
			DeviceProfile dp = (DeviceProfile) iterator.next();			
		}*/		
	} 
	
	public static RuntimePlatform createRuntimePlatform
		(String name, String description, DevicePlatform devicePlatform, EList deviceList, 
				RuntimePlatformDefinition rpd /*, DeviceProfile deviceProfile, DeviceConfiguration deviceConfiguration*/) 
	{	
		RuntimePlatform rp = RuntimesFactory.eINSTANCE.createRuntimePlatform();
		rp.setName(name);
		rp.setDescription(description);
		
		Iterator iterator = deviceList.iterator();
		while(iterator.hasNext()) {
			Device d = (Device) iterator.next();
			TargetDevice td = createTargetDevice(devicePlatform, rpd, d);
			// setRpdData(localRPD, deviceProfile, deviceConfiguration);
			rp.getTargetDevices().add(td);
		}
		return rp;
	}
	
	public EList getDeviceList(String devicePlatformName) {
		DevicePlatform dp = this.getDevicePlatform(devicePlatformName);
		if(dp != null) {
			return dp.getDevices();
		}
		return new BasicEList();
	}

	public void addRuntime(String name, String description) {
		runtimePlatform = createRuntimePlatform(name, description, devicePlatform, selectedRPD.getDevices()/*deviceList*/, selectedRPD);
	}
			
	public RuntimePlatform getAddedRuntime() {
		return runtimePlatform;
	}
	
	public DevicePlatform getSelectedDP() {
		return this.devicePlatform;
	}
	
	public void setSelectedDP(DevicePlatform devicePlatform) {
		this.devicePlatform = devicePlatform;
	}
	
	public void setSelectedRPD(RuntimePlatformDefinition selectedRPD) {
		this.selectedRPD = selectedRPD;
	}
	
	public RuntimePlatformDefinition getSelectedRPD() {
		return this.selectedRPD;
	}
}
