/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.rpm.preferences;

import java.util.logging.Logger;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.extension.rpm.Messages;
import org.eclipse.mtj.extension.rpm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.rpm.ui.preferences.RuntimeListComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RpmPreferencePage extends PreferencePage implements IWorkbenchPreferencePage {
	private static Logger log = Logger.getLogger(RpmPreferencePage.class.getName());

	private RuntimeListComposite runtimeListComposite;
	private RpmController rpmController;
	
	public RpmPreferencePage() {
		super();
		log.info(Messages.RpmPreferencePage_ConstructingRpmPreferencePage);
		setTitle(Messages.RpmPreferencePage_RuntimePlatform);
		setDescription(Messages.RpmPreferencePage_CreateAndModifyRuntimePlatforms);
	}

	protected Control createContents(Composite parent) {
		runtimeListComposite = new RuntimeListComposite(parent);
		rpmController = new RpmController(runtimeListComposite);
		return runtimeListComposite;
	}

	public void init(IWorkbench workbench) {
	}

	public void performDefaults() {
		MessageDialog dialog = new MessageDialog(
				this.getShell(),
				Messages.RpmController_Confirm,null,
				Messages.RpmPreferencePage_ConfirmRemovalDescription,
				MessageDialog.QUESTION, 
				new String[] {Messages.RpmController_Ok,Messages.RpmController_Cancel},0);
		if(dialog.open() == 0) {
			rpmController.setDefaults();
		}
	}
	
	private boolean storeRuntimes(RuntimePlatform[] runtimes) {
		boolean okToStore = MtjServiceHandler.storeRuntimes(runtimes);
		log.info("Runtime store performed in rpm preferences page : "+okToStore); //$NON-NLS-1$
		if (okToStore) {
			return super.performOk();
		} else {
			return okToStore;
		}		
	}
	
	public boolean performOk() {
		return storeRuntimes(rpmController.getRuntimePlatforms() != null ? rpmController.getRuntimePlatforms(): new RuntimePlatform[0]);
	}	
}
