/*******************************************************************************
* Copyright (c) 1998,2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
* Contributors:
*IBM - initial API and implementation
*******************************************************************************/
package org.eclipse.mtj.jad.util;


/**
 * A PropertyLine that corresponds to the triplicate spec of the MIDlet-N 
 * property found in a JAD file.
 *  
 * @author IBM
 **/
public class MIDletDescriptor extends PropertyLine {
	
	protected String name, icon, classname;

	MIDletDescriptor(String line) {
		setValue(line);
	}

	public MIDletDescriptor(String name, String icon, String classname) {
		setName(name);
		setIcon(icon);
		setClassname(classname);
		super.setValue(constructValue());
	}

	public String constructValue() {
		StringBuffer b = new StringBuffer();

		b.append(name).append(',');
		b.append(icon).append(',');
		b.append(classname);

		return b.toString();
	}
	
	public String[] getDescription(){
		return new String[] {name,icon,classname};
	}
	
	public void setValue(String value) {
		int comma1Index = value.indexOf(',');

		if (comma1Index != -1) {
			int comma2Index = value.indexOf(',', comma1Index + 1);
			setName(value.substring(0, comma1Index));
			/* If there is no icon name, skip it and set the icon value to empty string.*/
			setIcon(comma2Index > comma1Index + 1 ? value.substring(comma1Index + 1, comma2Index) : ""); //$NON-NLS-1$
			setClassname(value.substring(comma2Index + 1));
		}
		super.setValue(value);		
	}
	
	public static MIDletDescriptor convertFrom(PropertyLine line) {
		MIDletDescriptor descriptor = null;
		if (line instanceof MIDletDescriptor) {
			descriptor = (MIDletDescriptor)line;
		}
		else {
			descriptor = new MIDletDescriptor(line.getValue());
			descriptor.setKey(line.getKey());
			descriptor.setLeadingComment(line.getLeadingComment());					
		}
		return descriptor;
	}
	/**
	 * Returns the classname.
	 * @return String
	 */
	public String getClassname() {
		return classname;
	}

	/**
	 * Returns the icon.
	 * @return String
	 */
	public String getIcon() {
		return icon;
	}

	/**
	 * Returns the name.
	 * @return String
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the classname.
	 * @param classname The classname to set
	 */
	public void setClassname(String classname) {
		// .trim() statements are fixes for bug 93585	
		this.classname = classname.trim();
	}

	/**
	 * Sets the icon.
	 * @param icon The icon to set
	 */
	public void setIcon(String icon) {
		// .trim() statements are fixes for bug 93585		
		this.icon = icon.trim();
	}

	/**
	 * Sets the name.
	 * @param name The name to set
	 */
	public void setName(String name) {
		// .trim() statements are fixes for bug 93585		
		this.name = name.trim();
	}

}