/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.impl;

import java.util.ArrayList;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mtj.api.extension.DeviceDescriptionProvider;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.devices.DeviceDescription;
import org.eclipse.mtj.api.devices.DeviceGroup;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.enumerations.PlatformType;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.toolkit.ToolkitSupport;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dm.Messages;
import org.eclipse.mtj.extension.dm.MtjDeviceManagementPlugin;

public class DeviceManagementImpl extends MtjExtensionImpl implements
		DeviceManagement {

	public DeviceManagementImpl() {
		super();
		
		setId(MtjDeviceManagementPlugin.getDefault().getBundle().getSymbolicName());
		setDescription(Messages.DeviceManagementImpl_Description);
		setVendor(Messages.DeviceManagementImpl_Vendor);
		setVersion(Messages.DeviceManagementImpl_Version);
		setType(ExtensionType.DEVICE_MANAGEMENT_LITERAL);
	}

	public void removeDevicePlatform(DevicePlatform devicePlatform) throws MtjException {
		MtjExtension[] list = 
			MtjServices.getInstance()
				.getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
		boolean done = false;
		for (int i = 0; i < list.length; i++) {
			DevicePlatformProvider provider = (DevicePlatformProvider)list[i];
			try {
				DevicePlatform[] devicePlatforms = provider.getDevicePlatforms();
				for ( int j = 0; j < devicePlatforms.length; j++ ) {
					if (devicePlatforms[j].getDevicePlatformProvider().getId()
							.equals(devicePlatform.getDevicePlatformProvider().getId())) {
						DevicePlatformProvider dpp = (DevicePlatformProvider)(devicePlatforms[j].getDevicePlatformProvider());
						if (dpp instanceof ToolkitSupport) {
							DevicePlatform[] dps = dpp.getDevicePlatforms();
							if ( dps.length > 0 ) {
								DevicePlatform[] newDps = new DevicePlatform[dps.length - 1];
								int ix = 0;
								boolean found = false;
								for (int c = 0; c < dps.length; c++) {
									if (dps[c].getName().equals(devicePlatform.getName())) {
										found = true;
									}
									else {
										newDps[ix] = dps[c];
										ix++;
									}
								}
								if (found) {
									((ToolkitSupport)dpp).setDevicePlatforms(newDps);
									
									done = true;
									break;
								}
							}
						}
						else {
							throw new MtjException(Messages.DeviceManagementImpl_3);
						}
					}
				}
			} catch(Exception e) {
				throw new MtjException(Messages.DeviceManagementImpl_4,e);
			}
		}
		
		if (!done) {
			throw new MtjException(Messages.DeviceManagementImpl_5);
		}
	}
	
	public DevicePlatform[] getDevicePlatforms() throws MtjException {
		MtjExtension[] list = 
			MtjServices.getInstance()
				.getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
		ArrayList l = new ArrayList();
		for (int i = 0; i < list.length; i++) {
			DevicePlatformProvider provider = (DevicePlatformProvider)list[i];
			try {
				DevicePlatform[] devicePlatforms = provider.getDevicePlatforms();
				for ( int j = 0; j < devicePlatforms.length; j++ ) {
					l.add(devicePlatforms[j]);
				}
			} catch(Exception e) {
				e.printStackTrace();
			}
		}
		
		DevicePlatform[] resp = new DevicePlatform[l.size()];
		for (int i = 0; i < l.size(); i++) {
			resp[i] = (DevicePlatform)l.get(i);
		}
		return resp;
	}

	public Device[] getDevices(String devicePlatformName) throws MtjException {
		MtjExtension[] list = 
			MtjServices.getInstance()
				.getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
		for (int i = 0; i < list.length; i++) {
			DevicePlatform[] devicePlatforms = ((DevicePlatformProvider)list[i]).getDevicePlatforms();
			for ( int c = 0; c < devicePlatforms.length; c++ ) {
				DevicePlatform dp = devicePlatforms[c];
				if ( dp != null && dp.getName() != null && dp.getName().equals(devicePlatformName) ) {
					EList l = dp.getDevices();
					Device[] resp = new Device[l.size()];
					for (int j = 0; j < l.size(); j++) {
						resp[j] = (Device)l.get(j);
					}
					return resp;				
				}
			}
		}
		
		return null;
	}

	public Device getDevice(String devicePlatformName, String deviceName) throws MtjException {
		MtjExtension[] list = 
			MtjServices.getInstance()
				.getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
		for (int i = 0; i < list.length; i++) {
			DevicePlatform[] devicePlatforms = ((DevicePlatformProvider)list[i]).getDevicePlatforms();
			for ( int c = 0; c < devicePlatforms.length; c++ ) {
				DevicePlatform dp = devicePlatforms[c];
				if ( dp != null && dp.getName() != null && dp.getName().equals(devicePlatformName) ) {
					EList l = dp.getDevices();
					for (int j = 0; j < l.size(); j++) {
						Device device = (Device)l.get(j);
						if (device.getName() != null && device.getName().equals(deviceName) ) {
							return device;
						}
					}
				}
			}
		}
		
		return null;
	}

	public DeviceDescription getDeviceDescription(String vendor, String model)
			throws MtjException {
		MtjExtension[] list = 
			MtjServices.getInstance()
				.getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
		for (int i = 0; i < list.length; i++) {
			DeviceDescription dd = ((DeviceDescriptionProvider)list[i]).getDeviceDescription(vendor, model);
			if ( dd != null ) {
				return dd;				
			}
		}
		
		return null;
	}

	public DeviceDescription[] getMatchingDeviceDescriptions(DeviceGroup group)
			throws MtjException {
		MtjExtension[] list = 
			MtjServices.getInstance()
				.getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
		ArrayList l = new ArrayList();
		for (int i = 0; i < list.length; i++) {
			DeviceDescription[] dd = ((DeviceDescriptionProvider)list[i]).getMatchingDeviceDescriptions(group);
			if ( dd != null ) {
				for (int j = 0; j < dd.length; j++) {
					l.add(dd[j]);
				}
			}
		}
		
		DeviceDescription[] resp = new DeviceDescription[l.size()];
		for (int i = 0; i < l.size(); i++) {
			resp[i] = (DeviceDescription)l.get(i);
		}
		return resp;
	}

	public DeviceGroup[] getDeviceGroups() throws MtjException {
		MtjExtension[] list = 
			MtjServices.getInstance()
				.getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
		ArrayList l = new ArrayList();
		for (int i = 0; i < list.length; i++) {
			DeviceGroup[] dg = ((DeviceDescriptionProvider)list[i]).getDeviceGroups();
			if ( dg != null ) {
				for (int j = 0; j < dg.length; j++) {
					l.add(dg[j]);
				}
			}
		}
		
		DeviceGroup[] resp = new DeviceGroup[l.size()];
		for (int i = 0; i < l.size(); i++) {
			resp[i] = (DeviceGroup)l.get(i);
		}
		return resp;
	}

	public DeviceDescription[] getDevices(DeviceConfiguration deviceConfig,
			DeviceProfile deviceProfile, ServiceApi[] apis) throws MtjException {
		return null;
	}

	public Device[] getTargetDevices(DeviceConfiguration deviceConfig,
			DeviceProfile deviceProfile, ServiceApi[] apis,
			PlatformType devicePlatformType) throws MtjException {
		return null;
	}

	public RuntimePlatformDefinition[] getRuntimePlatforms(
			String devicePlatformName, String deviceName) throws MtjException {
		return null;
	}

	public Device[] getDeployableDevices(DeviceConfiguration deviceConfig,
			DeviceProfile deviceProfile, ServiceApi[] apis,
			PlatformType devicePlatformType) throws MtjException {
		return null;
	}
	
	/**
	 * Method returns existing device platform by name.
	 * 
	 * @return
	 */
	public DevicePlatform getDevicePlatformByName(String name) throws MtjException {
		DevicePlatform[] dps = getDevicePlatforms();
		for (int i = 0; i < dps.length; i++) {
			if (name.equals(dps[i].getName())) {
				return dps[i];
			}
		}
		
		// device platform not found
		return null;
	}

	/**
	 * Method returns the device platform provider that owns the device platform.
	 * 
	 * @param devicePlatform
	 * @return
	 * @throws MtjException
	 */
	public DevicePlatformProvider getDevicePlatformProvider(DevicePlatform devicePlatform) throws MtjException {
		MtjExtension[] list = 
			MtjServices.getInstance()
				.getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
		ArrayList l = new ArrayList();
		for (int i = 0; i < list.length; i++) {
			DevicePlatformProvider provider = (DevicePlatformProvider)list[i];
			DevicePlatform[] devicePlatforms = provider.getDevicePlatforms();
			for ( int c = 0; c < devicePlatforms.length; c++ ) {
				DevicePlatform dp = devicePlatforms[c];
				if (devicePlatform.getVendor() != null && devicePlatform.getVendor().equals(dp.getVendor()) &&
				    devicePlatform.getVersion() != null && devicePlatform.getVersion().equals(dp.getVersion()) && 
				    devicePlatform.getName() != null && devicePlatform.getName().equals(dp.getName())) {
					return provider;
				}
			}
		}
		throw new MtjException(Messages.DeviceManagementImpl_6);
	}

}
