/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.enumerations.BuildType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.exception.MtjException;

/**
 * Build Management is responsible to carry out the build process. 
 * 
 * </p>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:19 $
 * <br>
 */
public interface BuildManagement extends MtjExtension {

	/**
	 * Method <br>
	 * - collects Project data structure, that is described in the Build Provider section, from the project 
	 * that is given as parameter <br>
	 * - gets suitable Build Provider implementation from MTJ <br>
	 * - calls the Build Providers build method.
	 * 
	 * @param project
	 * @param projectNatureId
	 * @param buildType
	 * @param targetPlatform
	 * @param monitor
	 */
	public void build(IMtjProject project, String projectNatureId, BuildType buildType,
			RuntimePlatformDefinition targetPlatform,
			IProgressMonitor monitor) throws MtjException;

}
