/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.exception.MtjException;

/**
 * 
 * </p>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:19 $
 * <br>
 */
public interface DeploymentManagement extends MtjExtension 
{

	/**
	 * This method returns the Devices the could be deployment targets and that support the RuntimePlatformDefinition
	 * 
	 * @param runtimePlatformDefinition
	 * @return
	 * @throws MtjException
	 */
	public Device[] getTargetDevices(RuntimePlatformDefinition runtimePlatformDefinition) throws MtjException;

	/**
	 * This method returns DeploymentProvider that owns the Device
	 * 
	 * @param device
	 * @return
	 */
	public DeploymentProvider getDeploymentProvider(Device device);
	
	
	/**
	 * Method deploys the deployment -object to the target devices by using the defined transfer protocol.
	 * If transfer protocol parameter has null value, default transfer protocol is used.
	 * 
	 * @param deployment
	 * @param devices
	 * @param transferProtocol
	 * @param monitor
	 */
	public void deploy(Deployment deployment, Device[] devices,
			DeviceCommunicationProtocol transferProtocol,
			IProgressMonitor monitor) throws MtjException;
	
}
