/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 

package org.eclipse.mtj.api.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.extension.ProjectExtensionProvider;
import org.eclipse.mtj.api.model.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.exception.MtjException;

public interface IMtjProject {

	/**
	 * Get the IFolder into which verified classes should be written.
	 * 
	 * @param monitor progress monitor
	 * @return the verified classes output folder
	 * @throws CoreException
	 */
	public IFolder getVerifiedClassesOutputFolder(IProgressMonitor monitor)
			throws CoreException; 

	/**
	 * Get the IFolder into which verified libraries should be written.
	 * 
	 * @param monitor progress monitor
	 * @return the verified libraries output folder
	 * @throws CoreException
	 */
	public IFolder getVerifiedLibrariesOutputFolder(IProgressMonitor monitor)
			throws CoreException; 

	/**
	 * Get the IFolder into which deployment should be written.
	 * 
	 * @param monitor progress monitor
	 * @return the deployment output folder
	 * @throws CoreException
	 */
	public IFolder getDeploymentFolder(IProgressMonitor monitor) throws CoreException;

	/**
	 * Return the underlying project instance.
	 * 
	 * @return the underlying project
	 */
	public IProject getProject();

	/**
	 * Return the underlying Java project instance.
	 * 
	 * @return the underlying project
	 */
	public IJavaProject getJavaProject();
	
	/**
	 * Get the DevicePlatform in use for this project
	 * 
	 * @return the currently associated platform definition
	 */
	public DevicePlatform getPlatformDefinition() throws MtjException;
		
	/**
	 * Returns Project's Deployment
	 * @return
	 */
	public Deployment getDeployment() throws CoreException;
	
	/**
	 * Returns Project's Deployment to the target application
	 * 
	 * @param launchableApplication
	 * @return
	 * @throws CoreException
	 */
	public Deployment getDeployment(String launchableApplication) throws CoreException;
	
	/**
	 * Return a boolean indicating whether the project's deployed jar
	 * file exists and is up to date compared with the code contained
	 * within the jar.
	 * 
	 * @return whether the deployed jar file is currently up to date.
	 * @throws CoreException if there is a problem retrieving the information.
	 */
	public boolean isDeployedJarUpToDate() throws CoreException;

	/**
	 * Method returns Project data
	 * @return
	 * @throws MtjException
	 */
	public Project getProjectData() throws MtjException;
		
	/**
	 * Method sets Project data
	 * @param project
	 * @throws MtjException
	 */
	public void setProjectData(Project project) throws MtjException;

	/**
	 * Returns Project's default Device
	 * @return
	 * @throws MtjException
	 */
	public Device getDefaultDevice() throws MtjException;

	/**
	 * Returns Project's all Devices
	 * @return
	 * @throws MtjException
	 */
	public Device[] getDevices() throws MtjException;
	
	/**
	 * Method sets projectExtension to the project
	 * 
	 * @param projectExtension
	 */
	public void setProjectExtensionProvider(ProjectExtensionProvider projectExtension);

	/**
	 * Returns DevicePlatform's Device that corresponds the TargetDevice
	 * 
	 * @param targetDevice
	 * @return
	 * @throws MtjException
	 */
	public Device getDevice(TargetDevice targetDevice) throws MtjException;
	
	/**
	 * Return DeploymentType that the Project is supporting
	 * 
	 * @return
	 * @throws MtjException
	 */
	public DeploymentType getDeploymentType() throws CoreException;

	/**
	 * Return IJavaSearchScope object for searching classes that support the project's scope
	 * 
	 * @param javaProject
	 * @return
	 * @throws CoreException
	 */
	public IJavaSearchScope getJavaSearchScope(IJavaProject javaProject) throws CoreException;
	
	/**
	 * Returns PreverificationPolicy that the project supports
	 * 
	 * @param targetPlatform
	 * @return
	 */
	public IPreverificationPolicy getPreverificationPolicy(RuntimePlatformDefinition targetPlatform) throws CoreException;

	/**
	 * Returns Java Project's Classes' output folder
	 * 
	 * @param monitor
	 * @return
	 * @throws CoreException
	 */
	public IFolder getClassesOutputFolder(IProgressMonitor monitor) throws CoreException;
	
	/**
	 * Method initialized new Java Project
	 * 
	 * @param monitor
	 * @throws CoreException
	 */
	public void initializeNewProject(IProgressMonitor monitor) throws CoreException;
	
	/**
	 * Method updates new MTJ Projects classpath
	 * 
	 * @param monitor
	 * @throws CoreException
	 */
	public void updateProjectClasspath(IProgressMonitor monitor) throws CoreException;

}
