/**
 * Copyright (c) 2003-2004 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.api.model.preverifier;

/**
 * Interface that provides the policy information used during the process of
 * doing preverification.
 * <p />
 * Copyright (c) 2003-2004 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:21 $
 * <br>
 * @author Craig Setera
 */
public interface IPreverificationPolicy {
	/**
	 * Return a boolean indicating whether finalizer methods are allowed.
	 * 
	 * @return
	 */
	public boolean areFinalizersAllowed();
	
	/**
	 * Return a boolean indicating whether native methods are allowed.
	 * 
	 * @return
	 */
	public boolean areNativeMethodsAllowed();
	
	/**
	 * Return a boolean indicating whether floating point is allowed.
	 * 
	 * @return
	 */
	public boolean isFloatingPointAllowed();
}
