/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.api.model.preverifier;

import org.eclipse.mtj.core.Messages;

/**
 * Enumeration type to represent the location
 * of a preverication error.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:21 $
 * <br>
 * @author Craig Setera
 */
public class PreverificationErrorLocationType {
	private static final String[] STRINGS = new String[] {
		Messages.PreverificationErrorLocationType_ClassDeclaration,
		Messages.PreverificationErrorLocationType_ClassField,
		Messages.PreverificationErrorLocationType_MethodDefinition,
		Messages.PreverificationErrorLocationType_MethodField,
		Messages.PreverificationErrorLocationType_MethodInstruction,
		Messages.PreverificationErrorLocationType_UnknownLocation
	};
	
	/** The code representing a class declaration */
	public static final int CLASS_DEFINITION_CODE = 0;
	
	/** A class declaration */
	public static final PreverificationErrorLocationType CLASS_DEFINITION =
		new PreverificationErrorLocationType(CLASS_DEFINITION_CODE);
	
	/** The code representing a class field */
	public static final int CLASS_FIELD_CODE = 1;

	/** A class field location */
	public static final PreverificationErrorLocationType CLASS_FIELD = 
		new PreverificationErrorLocationType(CLASS_FIELD_CODE);

	/** The code representing a method definition error */
	public static final int METHOD_SIGNATURE_CODE = 2;
	
	/** The method definition location */
	public static final PreverificationErrorLocationType METHOD_SIGNATURE =
		new PreverificationErrorLocationType(METHOD_SIGNATURE_CODE);
	
	/** The code representing a method field definition error */
	public static final int METHOD_FIELD_CODE = 3;
	
	/** A method field location */
	public static final PreverificationErrorLocationType METHOD_FIELD =
		new PreverificationErrorLocationType(METHOD_FIELD_CODE);
	
	/** The method instruction location code */
	public static final int METHOD_INSTRUCTION_CODE = 4;
	
	/** A method instruction location */ 
	public static final PreverificationErrorLocationType METHOD_INSTRUCTION =
		new PreverificationErrorLocationType(METHOD_INSTRUCTION_CODE);
	
	/** The code when the location of the error is unknown */
	public static final int UNKNOWN_LOCATION_CODE = 5;
	
	/** The location of the error is unknown */
	public static final PreverificationErrorLocationType UNKNOWN_LOCATION =
		new PreverificationErrorLocationType(UNKNOWN_LOCATION_CODE);
	
	// The code representing the location
	private int typeCode;
	
	/**
	 * private constructor to limit options.
	 * 
	 * @param typeCode
	 */
	private PreverificationErrorLocationType(int typeCode) {
		super();
		this.typeCode = typeCode;
	}
	
	/**
	 * Return the location type code.
	 * 
	 * @return
	 */
	public int getTypeCode() {
		return typeCode;
	}
	
	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return STRINGS[typeCode];
	}
}
