/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.rpm.model;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.extension.PersistentStoreProvider;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.RuntimesFactory;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.util.MtjEmfUtil;
import org.eclipse.mtj.extension.rpm.Messages;

public class MtjServiceHandler {
    private static final Logger log = Logger.getLogger(MtjServiceHandler.class.getName());
    private DevicePlatform devicePlatform;
    private RuntimePlatform runtimePlatform;
    private RuntimePlatformDefinition selectedRPD;

    public RuntimePlatform getRuntimePlatform(RuntimePlatform[] rpa, TargetDevice targetDevice) {
        int i = 0;
        while (i < rpa.length) {
            for (TargetDevice td : rpa[i].getTargetDevices()) {
                if (!td.getDeviceName().equals(targetDevice.getDeviceName())) continue;
                return rpa[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean storeRuntimes(RuntimePlatform[] runtimePlatforms) {
        PersistentStoreProvider psp = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
        BasicEList runtimes = new BasicEList();
        int i = 0;
        while (i < runtimePlatforms.length) {
            runtimes.add((Object)runtimePlatforms[i]);
            ++i;
        }
        try {
            psp.store((Object)runtimes, 0, "runtimes", "org.eclipse.mtj.extension.rpm.ui", "MtjRuntimePlatforms");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static PersistentStoreProvider getPersistentStoreProvider() {
        return (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
    }

    private static EList getRuntimePlatforms(PersistentStoreProvider pstore) {
        try {
            return (EList)pstore.get(0, "runtimes", "org.eclipse.mtj.extension.rpm.ui", "MtjRuntimePlatforms");
        }
        catch (Exception e) {
            String message = MessageFormat.format(Messages.MtjServiceHandler_CouldNotProvideRuntimePlatformsWithFileNotFoundException, Messages.MtjServiceHandler_CouldNotProvideRuntimePlatforms, e.getMessage());
            log.log(Level.WARNING, message);
            return new BasicEList();
        }
    }

    public RuntimePlatform[] getRuntimePlatforms() {
        PersistentStoreProvider pstore = MtjServiceHandler.getPersistentStoreProvider();
        EList runtimePlatforms = MtjServiceHandler.getRuntimePlatforms(pstore);
        if (runtimePlatforms != null) {
            RuntimePlatform[] rps = new RuntimePlatform[runtimePlatforms.size()];
            int i = 0;
            while (i < runtimePlatforms.size()) {
                rps[i] = (RuntimePlatform)runtimePlatforms.get(i);
                ++i;
            }
            return rps;
        }
        return new RuntimePlatform[0];
    }

    public DevicePlatform[] getDevicePlatforms() {
        try {
            DeviceManagement dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null, true)[0];
            return dm.getDevicePlatforms();
        }
        catch (Exception e) {
            log.log(Level.WARNING, Messages.MtjServiceHandler_CouldNotProvideDevicePlatforms, e);
            return new DevicePlatform[0];
        }
    }

    public DevicePlatform getDevicePlatform(String name) {
        DevicePlatform[] dp = this.getDevicePlatforms();
        int i = 0;
        while (i < dp.length) {
            if (dp[i].getName().equals(name)) {
                return dp[i];
            }
            ++i;
        }
        return null;
    }

    public Device getDevice(DevicePlatform devicePlatform, String deviceName) {
        for (Device device : devicePlatform.getDevices()) {
            if (!device.getName().equals(deviceName)) continue;
            return device;
        }
        return null;
    }

    public RuntimePlatformDefinition getRuntimePlatformDefinition(String devicePlatformName, String deviceName) {
        try {
            DevicePlatform devicePlatform = this.getDevicePlatform(devicePlatformName);
            Device device = this.getDevice(devicePlatform, deviceName);
            if (device != null) {
                return (RuntimePlatformDefinition)device.getRuntimePlatformDefinitions().get(0);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, Messages.MtjServiceHandler_CouldNotProvideRuntimePlatformDefinitions, e);
        }
        return null;
    }

    public static TargetDevice createTargetDevice(DevicePlatform devicePlatform, RuntimePlatformDefinition rpd, Device device) {
        TargetDevice targetDevice = ProjectFactory.eINSTANCE.createTargetDevice();
        targetDevice.setName(String.valueOf(devicePlatform.getName()) + " - " + device.getName());
        targetDevice.setDescription(device.getDescription());
        targetDevice.setDeviceName(device.getName());
        targetDevice.setDevicePlatformName(devicePlatform.getName());
        RuntimePlatformDefinition localRPD = MtjEmfUtil.clone((RuntimePlatformDefinition)rpd);
        targetDevice.setRuntimePlatform(localRPD);
        return targetDevice;
    }

    public static void setRpdData(RuntimePlatformDefinition rpd, DeviceProfile deviceProfile, DeviceConfiguration deviceConfiguration) {
    }

    public static RuntimePlatform createRuntimePlatform(String name, String description, DevicePlatform devicePlatform, EList deviceList, RuntimePlatformDefinition rpd) {
        RuntimePlatform rp = RuntimesFactory.eINSTANCE.createRuntimePlatform();
        rp.setName(name);
        rp.setDescription(description);
        for (Device d : deviceList) {
            TargetDevice td = MtjServiceHandler.createTargetDevice(devicePlatform, rpd, d);
            rp.getTargetDevices().add((Object)td);
        }
        return rp;
    }

    public EList getDeviceList(String devicePlatformName) {
        DevicePlatform dp = this.getDevicePlatform(devicePlatformName);
        if (dp != null) {
            return dp.getDevices();
        }
        return new BasicEList();
    }

    public void addRuntime(String name, String description) {
        this.runtimePlatform = MtjServiceHandler.createRuntimePlatform(name, description, this.devicePlatform, this.selectedRPD.getDevices(), this.selectedRPD);
    }

    public RuntimePlatform getAddedRuntime() {
        return this.runtimePlatform;
    }

    public DevicePlatform getSelectedDP() {
        return this.devicePlatform;
    }

    public void setSelectedDP(DevicePlatform devicePlatform) {
        this.devicePlatform = devicePlatform;
    }

    public void setSelectedRPD(RuntimePlatformDefinition selectedRPD) {
        this.selectedRPD = selectedRPD;
    }

    public RuntimePlatformDefinition getSelectedRPD() {
        return this.selectedRPD;
    }
}

