/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.jadeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.extension.devide.jadeditor.AbstractJADEditorPage;
import org.eclipse.mtj.extension.devide.jadeditor.JADEditor;
import org.eclipse.mtj.extension.devide.jadeditor.JadEditorStrings;
import org.eclipse.mtj.extension.devide.jadeditor.ManifestPreferenceStore;
import org.eclipse.mtj.extension.devide.jadeditor.MidletSelectionDialogCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JADMidletsEditorPage
extends AbstractJADEditorPage {
    public static final String ID = "midlets";
    private static final String PROP_NAME = "name";
    private static final String PROP_ICON = "icon";
    private static final String PROP_CLASS = "class";
    private static final String[] PROPERTIES = new String[]{"name", "icon", "class"};
    private static final List PROPERTY_LIST = Arrays.asList(PROPERTIES);
    public static final String MIDLET_PREFIX = "MIDlet-";
    private ArrayList midlets = new ArrayList();
    private TableViewer tableViewer;
    private Button addButton;
    private Button removeButton;
    private int storedMidletCount;

    public JADMidletsEditorPage(JADEditor editor, String title) {
        super(editor, ID, title);
    }

    public void doSave(IProgressMonitor monitor) {
        ManifestPreferenceStore store = this.getPreferenceStore();
        int currentMidletCount = this.midlets.size();
        int i = 0;
        while (i < currentMidletCount) {
            MidletDefinition def = (MidletDefinition)this.midlets.get(i);
            store.setValue(MIDLET_PREFIX + (i + 1), def.toString());
            ++i;
        }
        while (i < this.storedMidletCount) {
            store.setToDefault(MIDLET_PREFIX + (i + 1));
            ++i;
        }
        this.storedMidletCount = currentMidletCount;
        this.setDirty(false);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = this.createSectionComposite(managedForm);
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(2, false));
        new Label(parent, 0);
        new Label(parent, 0);
        this.createTableViewer(toolkit, parent);
        this.createButtons(toolkit, parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "eclipseme.ui.help_JADMidletsEditorPage");
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    protected String getSectionTitle() {
        return "Midlets";
    }

    protected String getSectionDescription() {
        return "Define the Midlets that make up the Midlet Suite";
    }

    void editorInputChanged() {
        this.updateMidletProperties();
    }

    boolean isManagingProperty(String property) {
        boolean manages = property.startsWith(MIDLET_PREFIX);
        if (manages) {
            String value = property.substring(MIDLET_PREFIX.length());
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                manages = false;
            }
        }
        return manages;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)input);
        }
        this.setDirty(false);
        this.updateMidletProperties();
    }

    private void addItem() {
        MidletDefinition midletDefinition = new MidletDefinition("New Midlet", "", "");
        this.midlets.add(midletDefinition);
        this.tableViewer.refresh();
        this.setDirty(true);
    }

    private void createButtons(FormToolkit toolkit, Composite parent) {
        Composite composite = toolkit.createComposite(parent);
        FillLayout layout = new FillLayout();
        layout.type = 512;
        composite.setLayout((Layout)layout);
        this.addButton = toolkit.createButton(composite, JadEditorStrings.editor_button_add, 8);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADMidletsEditorPage.this.addItem();
            }
        });
        toolkit.createLabel(composite, "");
        this.removeButton = toolkit.createButton(composite, JadEditorStrings.editor_button_remove, 8);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADMidletsEditorPage.this.removeSelectedItems();
            }
        });
    }

    private void createTableViewer(FormToolkit toolkit, Composite parent) {
        String[] columns = new String[]{JadEditorStrings.editor_property_jad_midlet_name, JadEditorStrings.editor_property_jad_midlet_icon, JadEditorStrings.editor_property_jad_midlet_class};
        int styles = 68356;
        Table table = toolkit.createTable(parent, styles);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selected = (TableItem)e.item;
                JADMidletsEditorPage.this.removeButton.setEnabled(selected.getParent().getSelectionCount() > 0);
            }
        });
        this.tableViewer = new TableViewer(table);
        TableLayout layout = new TableLayout();
        int width = 100 / columns.length;
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columns[i]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(width));
            ++i;
        }
        table.setLayout((Layout)layout);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.tableViewer.setColumnProperties(PROPERTIES);
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new MidletCellEditor((Composite)table)});
        this.tableViewer.setInput((Object)this.getEditorInput());
        this.tableViewer.refresh();
    }

    private IJavaProject getJavaProject() {
        IProject project = this.getProject();
        return project == null ? null : JavaCore.create((IProject)project);
    }

    private IProject getProject() {
        IProject project = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            project = file.getProject();
        }
        return project;
    }

    private void removeSelectedItems() {
        int[] indices = this.tableViewer.getTable().getSelectionIndices();
        int i = indices.length;
        while (i > 0) {
            int index = indices[i - 1];
            this.midlets.remove(index);
            --i;
        }
        this.setDirty(true);
        this.tableViewer.refresh();
    }

    private void updateMidletProperties() {
        this.midlets.clear();
        ManifestPreferenceStore store = this.getPreferenceStore();
        int i = 1;
        while (i < 1000) {
            String propName = MIDLET_PREFIX + i;
            if (!store.contains(propName)) break;
            String propValue = store.getString(propName);
            this.midlets.add(new MidletDefinition(propValue));
            ++i;
        }
        this.storedMidletCount = this.midlets.size();
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    static class MidletDefinition {
        public String[] fields = new String[3];

        MidletDefinition(String definitionString) {
            String[] tokens = this.tokenize(definitionString, ',');
            int i = 0;
            while (i < 3) {
                this.fields[i] = i > tokens.length ? "" : tokens[i];
                ++i;
            }
        }

        MidletDefinition(String name, String icon, String className) {
            this.fields[0] = name;
            this.fields[1] = icon;
            this.fields[2] = className;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < 3) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.fields[i]);
                ++i;
            }
            return sb.toString();
        }

        private String[] tokenize(String string, char delimiter) {
            ArrayList<String> tokens = new ArrayList<String>();
            int offset = 0;
            int delimiterIndex = 0;
            do {
                if ((delimiterIndex = string.indexOf(delimiter, offset)) == -1) {
                    tokens.add(string.substring(offset));
                    continue;
                }
                tokens.add(string.substring(offset, delimiterIndex));
                offset = delimiterIndex + 1;
            } while (delimiterIndex != -1);
            return tokens.toArray(new String[tokens.size()]);
        }
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            String value = null;
            if (element instanceof MidletDefinition) {
                MidletDefinition midletDef = (MidletDefinition)element;
                int fieldIndex = this.getFieldIndex(property);
                if (fieldIndex != -1) {
                    value = midletDef.fields[fieldIndex];
                }
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                Object data = ((TableItem)element).getData();
                String newValue = (String)value;
                if (data instanceof MidletDefinition) {
                    int fieldIndex = this.getFieldIndex(property);
                    MidletDefinition midletDef = (MidletDefinition)data;
                    if (fieldIndex != -1) {
                        this.updateField(midletDef, property, fieldIndex, newValue);
                    }
                }
            }
        }

        private int getFieldIndex(String property) {
            return PROPERTY_LIST.indexOf(property);
        }

        private void updateField(MidletDefinition midletDef, String property, int fieldIndex, String newValue) {
            if (!midletDef.fields[fieldIndex].equals(newValue)) {
                midletDef.fields[fieldIndex] = newValue;
                JADMidletsEditorPage.this.setDirty(true);
                JADMidletsEditorPage.this.tableViewer.update((Object)midletDef, new String[]{property});
            }
        }
    }

    private class MidletCellEditor
    extends DialogCellEditor {
        MidletCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            String value = null;
            try {
                IType type;
                Object[] results;
                IJavaProject javaProject = JADMidletsEditorPage.this.getJavaProject();
                SelectionDialog dialog = MidletSelectionDialogCreator.createMidletSelectionDialog(cellEditorWindow.getShell(), (IRunnableContext)JADMidletsEditorPage.this.getSite().getPage().getWorkbenchWindow(), javaProject, false);
                if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0 && (type = (IType)results[0]) != null) {
                    value = type.getFullyQualifiedName();
                }
            }
            catch (JavaModelException e) {
                MtjCorePlugin.log((int)4, (String)"openDialogBox", (Throwable)e);
            }
            return value;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return JADMidletsEditorPage.this.midlets.toArray(new Object[JADMidletsEditorPage.this.midlets.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((MidletDefinition)element).fields[columnIndex];
        }
    }
}

