/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.preferences;

import org.eclipse.mtj.api.devices.ConfigurationItem;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.core.ui.util.DialogController;
import org.eclipse.mtj.extension.dm.ui.preferences.DevicePlatformInfoComposite;

public class DevicePlatformInfoController
implements DialogController {
    private DevicePlatformInfoComposite composite;
    private DevicePlatform selectedPlatform;

    public DevicePlatformInfoController(DevicePlatformInfoComposite composite, DevicePlatform selectedPlatform) {
        this.composite = composite;
        this.selectedPlatform = selectedPlatform;
        this.setData();
    }

    private void setData() {
        this.composite.getNameLabel().setText(this.selectedPlatform.getName());
        this.composite.getVendorLabel().setText(this.selectedPlatform.getVendor());
        this.composite.getVersionLabel().setText(this.selectedPlatform.getVersion());
        this.composite.getLocationLabel().setText(this.getRootDirectory(this.selectedPlatform));
    }

    private String getRootDirectory(DevicePlatform dp) {
        for (ConfigurationItem item : dp.getConfiguration().getItems()) {
            String d;
            if (!"directory".equals(item.getName()) || (d = item.getValue()) == null) continue;
            if ((d = d.replace('\\', '/')).endsWith("/")) {
                d = d.substring(0, d.length() - 1);
            }
            return d;
        }
        return "";
    }

    public void handleOK() {
    }
}

