/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.jad.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class ConvertNativeToUTF8 {
    public static InputStream convertNativeToUTF8(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream dais = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf8"));
            dais = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)dais, "utf8");
            BufferedWriter bw = new BufferedWriter(osw);
            String tmpString = "";
            while (tmpString != null) {
                tmpString = bufferedReader.readLine();
                if (tmpString == null) continue;
                String outputString = String.valueOf(tmpString.trim()) + "\n";
                bw.write(outputString);
            }
            bw.close();
        }
        catch (EOFException eOFException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteArrayInputStream bais = dais != null ? new ByteArrayInputStream(dais.toByteArray()) : new ByteArrayInputStream("".getBytes());
        return bais;
    }

    public static String convertUTF8ToNative(String inputString) {
        if (inputString == null) {
            return null;
        }
        try {
            String outputString = new String(inputString.getBytes(), "utf8");
            return outputString;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String convertNativeToUTF8(String inputString) {
        if (inputString == null) {
            return null;
        }
        try {
            String outputString = new String(inputString.getBytes("utf8"));
            return outputString;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }
}

