/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.smgmt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.bp.eclipse.midp.MidpSigning;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.smgmt.ui.SecurityManagmentUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class PopUpAction
implements IObjectActionDelegate {
    private IMtjProject fTargetProject = null;
    private MidpSigning midpSigning = null;
    private boolean SignAction = false;
    private Shell shell;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (action.getId().endsWith(".unsigncontribution")) {
            this.SignAction = false;
        } else if (action.getId().endsWith(".signcontribution")) {
            this.SignAction = true;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        this.shell = display == null ? new Shell() : display.getActiveShell();
        try {
            if (this.fTargetProject != null && this.fTargetProject.getProjectData().getType() == ProjectType.PROJECT_TYPE_MIDP_LITERAL) {
                try {
                    new ProgressMonitorDialog(this.shell).run(false, false, this.getSignMidletRunnable());
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (MtjException mtjException) {}
    }

    public IRunnableWithProgress getSignMidletRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                PopUpAction.this.midpSigning = new MidpSigning(PopUpAction.this.fTargetProject, monitor);
                if (PopUpAction.this.SignAction) {
                    PopUpAction.this.midpSigning.preemtSign();
                    if (PopUpAction.this.midpSigning.canSign()) {
                        PopUpAction.this.midpSigning.sign();
                    } else {
                        PopUpAction.this.midpSigning.displaySigningStepMessage(new MtjException(), SecurityManagmentUIMessages.PopUpAction_2, SecurityManagmentUIMessages.PopUpAction_3, 1);
                    }
                } else {
                    PopUpAction.this.midpSigning.unsign();
                }
            }
        };
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            this.fTargetProject = this.getFirstProject(((IStructuredSelection)selection).toList());
        }
    }

    private IMtjProject getFirstProject(List list) {
        IMtjProject firstProject = null;
        for (Object element : list) {
            IResource res;
            if (!(element instanceof IAdaptable) || (res = (IResource)((IAdaptable)element).getAdapter(IResource.class)) == null) continue;
            try {
                firstProject = MtjProject.getMtjProject((IJavaProject)new JavaProject(res.getProject(), null));
            }
            catch (MtjException mtjException) {}
        }
        return firstProject;
    }
}

