/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.nature;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class MtjNature
implements IProjectNature {
    public static final String PLUGIN_ID = "org.eclipse.mtj.extension.devide";
    public static final String MTJ_NATURE_ID = "org.eclipse.mtj.extension.devide.nature";
    private IProject project;

    public static boolean hasMtjNature(IProject project) throws CoreException {
        return project.hasNature(MTJ_NATURE_ID);
    }

    public static String getNatureID() {
        return MTJ_NATURE_ID;
    }

    public void configure() throws CoreException {
        this.addMtjBuilders();
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private void addMtjBuilders() throws CoreException {
        boolean updated = false;
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        ArrayList commandsList = new ArrayList(Arrays.asList(commands));
        Object command = null;
        if (commandsList != null && !commandsList.contains(command)) {
            commandsList.add(command);
            updated = true;
        }
        if (updated) {
            ICommand[] newCommands = commandsList.toArray(new ICommand[commandsList.size()]);
            description.setBuildSpec(newCommands);
            this.getProject().setDescription(description, null);
        }
    }

    private ICommand newCommand(IProjectDescription description, String id) {
        ICommand command = description.newCommand();
        command.setBuilderName(id);
        return command;
    }
}

