/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import java.util.Calendar;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.core.util.MtjEmfUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.mtj.extension.devide.core.J2MEClasspathContainer;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.rpm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.rpm.model.RpmUIManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MTJNewProjectSelectLibraryWizardPage
extends WizardPage
implements IClasspathContainerPage {
    Combo swt_combo_type;
    HashMap rpMap;
    public IClasspathEntry fSelection;
    public IProject project;
    static Calendar calendarReference = null;
    private static final String RPM_PREFERENCES_ID = "org.eclipse.mtj.extension.rpm.preferences.RpmPreferencePage";
    private static final String DM_PREFERENCES_ID = "org.eclipse.mtj.extension.dm.preferences.DmPreferencePage";
    private static final String SECURITY_PREFERENCES_ID = "org.eclipse.mtj.extension.smgmt.ui.eclipse.preferences.SecurityManagementPreferencePage";
    private static final String SIGNING_PREFERENCES_ID = "org.eclipse.mtj.extension.sp.ui.eclipse.preferences.SigningPreferencePage";

    public MTJNewProjectSelectLibraryWizardPage() {
        super("");
    }

    public MTJNewProjectSelectLibraryWizardPage(String pageName) {
        super(pageName);
    }

    public MTJNewProjectSelectLibraryWizardPage(String pageName, IProject projectReference) {
        super(pageName);
        this.project = projectReference;
    }

    public void setLabels() {
        this.setTitle(Messages.MTJNewProjectSelectLibraryWizardPage_MTJ_JavaMe_library_addition);
        this.setDescription(Messages.MTJNewProjectSelectLibraryWizardPage_Select_appropriate_SDK);
        this.setImageDescriptor(MtjDevIdePlugin.getImageDescriptor("icons/full/wiz/add_edit_device_platform_mgmt_wiz.png"));
    }

    public void createControl(Composite parent) {
        this.setLabels();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Label referenceLabel = new Label(composite, 0);
        referenceLabel.setText(Messages.MTJNewProjectSelectLibraryWizardPage_Select_runtime_platform);
        this.swt_combo_type = new Combo(composite, 2060);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.addRuntimePlatforms();
        this.swt_combo_type.setLayoutData((Object)gd);
        this.swt_combo_type.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MTJNewProjectSelectLibraryWizardPage.this.setPageComplete(MTJNewProjectSelectLibraryWizardPage.this.isPageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite c = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        c.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        c.setLayoutData((Object)data);
        Link lnkConfigure = new Link(composite, 0);
        gd = new GridData(1, 4, true, false);
        lnkConfigure.setLayoutData((Object)gd);
        lnkConfigure.setText(Messages.MTJNewProjectSelectLibraryWizardPage_Configure_runtime_platform_link);
        lnkConfigure.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MTJNewProjectSelectLibraryWizardPage.this.openPreferences();
                MTJNewProjectSelectLibraryWizardPage.this.addRuntimePlatforms();
                MTJNewProjectSelectLibraryWizardPage.this.setPageComplete(MTJNewProjectSelectLibraryWizardPage.this.isPageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MTJNewProjectSelectLibraryWizardPage.this.openPreferences();
                MTJNewProjectSelectLibraryWizardPage.this.addRuntimePlatforms();
                MTJNewProjectSelectLibraryWizardPage.this.setPageComplete(MTJNewProjectSelectLibraryWizardPage.this.isPageComplete());
            }
        });
        this.setControl((Control)composite);
    }

    private void openPreferences() {
        String[] preferencePages = new String[]{RPM_PREFERENCES_ID, DM_PREFERENCES_ID, SECURITY_PREFERENCES_ID, SIGNING_PREFERENCES_ID};
        PreferenceDialog prefdlg = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getCurrent().getActiveShell(), (String)RPM_PREFERENCES_ID, (String[])preferencePages, null);
        prefdlg.open();
    }

    private void openRuntimePlatform() {
        if (this.getRuntimePlatform() != null) {
            RpmUIManager.editRuntimePlatform((RuntimePlatform)this.getRuntimePlatform(), (Composite)this.getShell());
        }
    }

    private void addRuntimePlatforms() {
        this.swt_combo_type.removeAll();
        RuntimePlatform[] rps = new MtjServiceHandler().getRuntimePlatforms();
        this.rpMap = new HashMap();
        if (rps != null) {
            int i = 0;
            while (i < rps.length) {
                String name = String.valueOf(rps[i].getName()) + " - " + rps[i].getDescription();
                this.swt_combo_type.add(name);
                this.rpMap.put(name, rps[i]);
                this.swt_combo_type.select(i);
                ++i;
            }
        }
    }

    private void addNewRuntimePlatform() {
        if (RpmUIManager.addRuntimePlatform((Shell)this.getShell(), (boolean)true) == 0) {
            this.addRuntimePlatforms();
            this.setPageComplete(this.isPageComplete());
        }
    }

    public boolean isPageComplete() {
        return this.isRuntimePlatformInDialog();
    }

    private boolean isRuntimePlatformInDialog() {
        return this.swt_combo_type.getText() != null && this.swt_combo_type.getText().compareTo("") != 0;
    }

    private RuntimePlatform getRuntimePlatform() {
        return (RuntimePlatform)this.rpMap.get(this.swt_combo_type.getText());
    }

    public TargetDevice[] getProjectModelData() {
        RuntimePlatform rp = this.getRuntimePlatform();
        EList list = rp.getTargetDevices();
        TargetDevice[] tds = new TargetDevice[list.size()];
        int i = 0;
        while (i < list.size()) {
            tds[i] = MtjEmfUtil.clone((TargetDevice)((TargetDevice)list.get(i)));
            ++i;
        }
        return tds;
    }

    public boolean finish() {
        this.setSelection(this.createSelection());
        TargetDevice[] targetDevice = this.getProjectModelData();
        Project project = ProjectFactory.eINSTANCE.createProject();
        if (targetDevice != null && targetDevice.length > 0) {
            project.setDefaultTargetDevice(targetDevice[0]);
        }
        if (targetDevice != null && targetDevice.length > 1) {
            int i = 1;
            while (i < targetDevice.length) {
                project.getTargetDevices().add((Object)targetDevice[i]);
                ++i;
            }
        }
        try {
            String timeInMillis = Long.toString(calendarReference.getTimeInMillis());
            IPath location = MtjProject.getMetadataTemporaryStorage(timeInMillis);
            MtjProject.setProjectDataTemporaryLocation(project, location);
        }
        catch (MtjException e) {
            e.printStackTrace();
        }
        return true;
    }

    public IClasspathEntry getSelection() {
        System.out.println(Messages.MTJNewProjectSelectLibraryWizardPage_8);
        return this.fSelection;
    }

    public IClasspathEntry createSelection() {
        if (this.fSelection != null) {
            return this.fSelection;
        }
        if (calendarReference == null) {
            calendarReference = Calendar.getInstance();
        }
        Path entryPath = new Path(J2MEClasspathContainer.J2ME_CONTAINER);
        String timeInMillis = Long.toString(calendarReference.getTimeInMillis());
        entryPath = entryPath.append(timeInMillis);
        IClasspathEntry newEntry = JavaCore.newContainerEntry((IPath)entryPath);
        return newEntry;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.fSelection = containerEntry;
    }
}

