/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class MTJNewProjectTemplatePage
extends WizardPage {
    private Button useTemplateCheckBox;
    private List templatesList;
    private boolean useTemplate;
    private String templateToUse;
    private IProject fproject;
    private IPath templatesDir;
    private IPath srcPath;
    private String srcSegment;
    private boolean forMIDP;

    public MTJNewProjectTemplatePage(boolean forMIDP) {
        super("");
        this.setTitle(Messages.MTJNewProjectTemplatePage_0);
        this.setMessage(Messages.MTJNewProjectTemplatePage_1);
        this.templatesDir = MtjDevIdePlugin.getTemplatesPath(forMIDP ? (byte)1 : 2);
        this.srcSegment = MtjDevIdePlugin.getTemplatesSegments(forMIDP ? (byte)1 : 2);
        this.forMIDP = forMIDP;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Composite c = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        c.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        c.setLayoutData((Object)data);
        this.useTemplateCheckBox = new Button(c, 32);
        GridData gd = new GridData(1);
        this.useTemplateCheckBox.setSelection(false);
        this.useTemplateCheckBox.setLayoutData((Object)gd);
        this.useTemplateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean checkSelection = MTJNewProjectTemplatePage.this.useTemplateCheckBox.getSelection();
                if (MTJNewProjectTemplatePage.this.getErrorMessage() != null && MTJNewProjectTemplatePage.this.getErrorMessage().equals(Messages.MTJNewProjectTemplatePage_2)) {
                    MTJNewProjectTemplatePage.this.setErrorMessage(null);
                }
                MTJNewProjectTemplatePage.this.templatesList.setEnabled(checkSelection);
                MTJNewProjectTemplatePage.this.setUseTemplate(checkSelection);
                if (checkSelection) {
                    if (MTJNewProjectTemplatePage.this.templatesList.getSelectionIndex() == -1 && MTJNewProjectTemplatePage.this.templatesList.getItemCount() > 0) {
                        MTJNewProjectTemplatePage.this.templatesList.setSelection(0);
                    }
                    MTJNewProjectTemplatePage.this.setTemplateToUse(MTJNewProjectTemplatePage.this.templatesList.getItem(MTJNewProjectTemplatePage.this.templatesList.getSelectionIndex()));
                } else {
                    MTJNewProjectTemplatePage.this.setTemplateToUse(null);
                }
            }
        });
        Label useTemplateLabel = new Label(c, 0);
        gd = new GridData(1);
        useTemplateLabel.setLayoutData((Object)gd);
        useTemplateLabel.setText(Messages.MTJNewProjectTemplatePage_3);
        this.templatesList = new List(composite, 2564);
        gd = new GridData(1808);
        this.templatesList.setLayoutData((Object)gd);
        this.templatesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MTJNewProjectTemplatePage.this.templatesList.getSelectionCount() > 0) {
                    MTJNewProjectTemplatePage.this.setTemplateToUse(MTJNewProjectTemplatePage.this.templatesList.getItem(MTJNewProjectTemplatePage.this.templatesList.getSelectionIndex()));
                    MTJNewProjectTemplatePage.this.useTemplateCheckBox.setSelection(true);
                    MTJNewProjectTemplatePage.this.setUseTemplate(true);
                    if (MTJNewProjectTemplatePage.this.getErrorMessage() != null && MTJNewProjectTemplatePage.this.getErrorMessage().equals(Messages.MTJNewProjectTemplatePage_2)) {
                        MTJNewProjectTemplatePage.this.setErrorMessage(null);
                    }
                }
            }
        });
        this.templatesList.setEnabled(false);
        this.addTemplateFilestoList(this.templatesList);
        this.setControl((Control)composite);
    }

    private void addTemplateFilestoList(List templatesList) {
        String[] files = MtjDevIdePlugin.getTemplateFiles(this.forMIDP ? (byte)1 : 2);
        int i = 0;
        while (i < files.length) {
            templatesList.add(files[i]);
            ++i;
        }
    }

    public void doFinish() {
        String srcTemplateName = String.valueOf(this.getTemplateToUse()) + ".template";
        if (this.getErrorMessage() == null && this.useTemplate() && srcTemplateName != null) {
            IPath templateSrcPath = new Path(this.templatesDir.toString()).append(String.valueOf(File.separator) + srcTemplateName.toString());
            String dstJavaPackageName = this.createPackageName(templateSrcPath);
            String dstJavaFileName = this.convertTemplatetoJava(templateSrcPath);
            IPath templateDestPath = this.fproject.getLocation().addTrailingSeparator().append(this.getSrcPath().lastSegment());
            File newPackage = new File(templateDestPath.append(String.valueOf(File.separator) + dstJavaPackageName).toString().toLowerCase());
            newPackage.mkdir();
            try {
                Path p = new Path(String.valueOf(this.srcSegment) + File.separator + this.getTemplateToUse() + ".template");
                InputStream is = ((Object)((Object)MtjDevIdePlugin.getDefault())).getClass().getClassLoader().getResourceAsStream(p.toPortableString());
                BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(is));
                BufferedWriter out = new BufferedWriter(new FileWriter(templateDestPath.append(String.valueOf(File.separator) + dstJavaPackageName + File.separator + dstJavaFileName).toString()));
                try {
                    try {
                        String fileInput;
                        while ((fileInput = cmdOutputStream.readLine()) != null) {
                            out.write(fileInput);
                            out.newLine();
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                finally {
                    this.fproject.refreshLocal(2, null);
                    cmdOutputStream.close();
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String createPackageName(IPath templateSrcPath) {
        String s = templateSrcPath.removeFileExtension().lastSegment().concat("_package");
        return s.toString();
    }

    private String convertTemplatetoJava(IPath templateSrcPath) {
        IPath s = new Path(templateSrcPath.removeFileExtension().lastSegment()).addFileExtension("java");
        return s.toString();
    }

    public void setProject(IProject project) {
        this.fproject = project;
    }

    public IProject getProject() {
        return this.fproject;
    }

    public String getTemplateToUse() {
        return this.templateToUse;
    }

    public void setTemplateToUse(String templateToUse) {
        this.templateToUse = templateToUse;
    }

    public boolean useTemplate() {
        return this.useTemplate;
    }

    public void setUseTemplate(boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    public void setSrcPath(IClasspathEntry srcEntry) {
        this.srcPath = srcEntry.getPath();
    }

    public IPath getSrcPath() {
        return this.srcPath;
    }
}

