/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.bp.eclipse;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.BuildType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.extension.BuildProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.bp.eclipse.Messages;
import org.eclipse.mtj.extension.bp.eclipse.javame.JavaMePackaging;
import org.eclipse.mtj.extension.bp.eclipse.midp.MidpPackaging;
import org.eclipse.mtj.extension.bp.eclipse.midp.MidpPreverify;
import org.eclipse.mtj.extension.bp.eclipse.midp.MidpSigning;

public class BuildProviderImpl
extends MtjExtensionImpl
implements BuildProvider {
    public BuildProviderImpl() {
        this.setId("org.eclipse.mtj.extension.bp.eclipse");
        this.setDescription(Messages.BuildProviderImpl_PluginDescription);
        this.setVendor(Messages.BuildProviderImpl_PluginProvider);
        this.setVersion(Messages.BuildProviderImpl_PluginVersion);
        this.setType(ExtensionType.BUILD_PROVIDER_LITERAL);
    }

    public BuildType[] getSupportedTypes() throws MtjException {
        BuildType[] ret = new BuildType[]{BuildType.BUILD_TYPE_ECLIPSE_LITERAL};
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Deployment build(IMtjProject mtjProject, String projectNatureId, BuildType type, RuntimePlatformDefinition targetPlatform, IProgressMonitor monitor) throws MtjException {
        if (mtjProject.getProjectData().getType() == ProjectType.PROJECT_TYPE_MIDP_LITERAL) {
            try {
                MidpSigning midpSigning = new MidpSigning(mtjProject, monitor);
                midpSigning.preemtSign();
                MidpPreverify preVerify = new MidpPreverify(mtjProject, monitor);
                preVerify.performPreverify(targetPlatform);
                MidpPackaging packaging = new MidpPackaging(mtjProject, monitor);
                packaging.performPackaging(projectNatureId);
                if (!midpSigning.canSign()) return null;
                midpSigning.sign();
                return null;
            }
            catch (MtjException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)1026), (Throwable)e);
            }
        }
        try {
            JavaMePackaging packaging = new JavaMePackaging(mtjProject, monitor);
            packaging.performPackaging(projectNatureId);
            return null;
        }
        catch (MtjException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)1026), (Throwable)e);
        }
    }
}

