/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.executable.uei;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.api.model.IExecutablePlatform;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.launching.LaunchHelper;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.executable.uei.UeiPropertiesCache;
import org.eclipse.mtj.extension.devide.executable.AbstractExecutable;
import org.eclipse.mtj.extension.devide.project.MtjProject;

public class UeiExecutable
extends AbstractExecutable
implements IExecutablePlatform {
    public static final String PROP_CLASSPATH = "bootclasspath";
    public static final String PROP_KNOWN_ARGUMENTS = "uei.arguments";
    public static final String PROP_DEVICE_LIST = "device.list";
    public static final String EXECUTABLE_PATH = "bin/emulator";
    private File emulatorExecutable;
    private Properties ueiProperties;
    private Set knownArguments;
    private DevicePlatform devicePlatform;
    private Device device;

    public UeiExecutable(DevicePlatform devicePlatform, Device device) {
        this.devicePlatform = devicePlatform;
        this.device = device;
    }

    public static File getEmulatorExecutable(File directory) {
        return new File(directory, EXECUTABLE_PATH);
    }

    public File getExecutable() throws CoreException {
        if (this.emulatorExecutable == null) {
            String rootDir;
            DevicePlatformProvider devicePlatformProvider = (DevicePlatformProvider)this.devicePlatform.getDevicePlatformProvider();
            if (devicePlatformProvider == null) {
                Status status = new Status(4, "org.eclipse.mtj.core.ui", 3073, MtjCoreErrors.getErrorMessage((int)3073), null);
                throw new CoreException((IStatus)status);
            }
            try {
                rootDir = devicePlatformProvider.getRootDirectory(this.devicePlatform);
            }
            catch (MtjException e) {
                Status status = new Status(4, "org.eclipse.mtj.core.ui", 3074, MtjCoreErrors.getErrorMessage((int)3074), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            this.emulatorExecutable = UeiExecutable.getEmulatorExecutable(new File(rootDir));
        }
        return this.emulatorExecutable;
    }

    public String getArguments(ILaunchConfiguration configuration, Deployment deployment, boolean debugMode, int debugPort, String natureId, Device device) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ArrayList arguments = new ArrayList();
        if (debugMode) {
            this.addDebugArguments(arguments, debugPort, true);
        }
        if (!this.isPredeploymentRequired(configuration)) {
            this.addClasspath(arguments, configuration, natureId, (IProgressMonitor)monitor);
        }
        this.addDeviceArgument(arguments, configuration, device);
        this.addDescriptorArgument(arguments, deployment, configuration, device);
        this.addMiscellaneousArguments(arguments, configuration, device);
        this.addSecurityDomain(arguments, configuration);
        this.addExtraLaunchArguments(arguments, configuration);
        this.addEmulationTarget(arguments, configuration, deployment, device);
        if (this.isKeepAlivePortRequired(configuration)) {
            this.addKeepAlivePort(arguments, configuration);
        }
        return this.convertArgsToString(arguments);
    }

    private boolean isPredeploymentRequired(ILaunchConfiguration configuration) throws CoreException {
        DevicePlatform devicePlatform = LaunchHelper.getTargetLaunchDevicePlatform((ILaunchConfiguration)configuration);
        return devicePlatform.isPredeploymentRequired();
    }

    protected void addDescriptorArgument(ArrayList arguments, ILaunchConfiguration configuration, Deployment deployment) throws CoreException {
        if (this.isKnownArgument("Xdescriptor")) {
            super.addDescriptorArgument(arguments, configuration, deployment);
        }
    }

    protected void addDeviceArgument(ArrayList arguments, ILaunchConfiguration configuration, Device device) throws CoreException {
        if (this.isKnownArgument("Xdevice")) {
            this.addLaunchConfigurationArgument(arguments, configuration, device, "-Xdevice:", false);
        }
    }

    protected boolean isKnownArgument(String argument) throws CoreException {
        Set knownArgs = this.getKnownUEIArguments(this.device);
        return knownArgs.size() == 0 || knownArgs.contains(argument);
    }

    protected Set getKnownUEIArguments(Device device) throws CoreException {
        if (this.knownArguments == null) {
            this.knownArguments = new HashSet();
            String commaSeparatedArgs = this.getUEIProperties().getProperty(PROP_KNOWN_ARGUMENTS);
            if (commaSeparatedArgs == null) {
                String propName = String.valueOf(device.getName()) + "." + PROP_KNOWN_ARGUMENTS;
                commaSeparatedArgs = this.getUEIProperties().getProperty(propName, "");
            }
            StringTokenizer st = new StringTokenizer(commaSeparatedArgs, ",");
            while (st.hasMoreTokens()) {
                this.knownArguments.add(st.nextToken().trim());
            }
        }
        return this.knownArguments;
    }

    public Properties getUEIProperties() throws CoreException {
        if (this.ueiProperties == null) {
            this.ueiProperties = UeiPropertiesCache.instance.getUEIProperties(this.getExecutable());
        }
        return this.ueiProperties;
    }

    protected boolean isExecutableTargetRequired(ILaunchConfiguration configuration) throws CoreException {
        DevicePlatform devicePlatform = LaunchHelper.getTargetLaunchDevicePlatform((ILaunchConfiguration)configuration);
        return devicePlatform.isExecutableTargetRequired();
    }

    protected boolean isKeepAlivePortRequired(ILaunchConfiguration configuration) throws CoreException {
        DevicePlatform devicePlatform = LaunchHelper.getTargetLaunchDevicePlatform((ILaunchConfiguration)configuration);
        return devicePlatform.isKeepAlivePortRequired();
    }

    protected IMtjProject getMtjProject(IJavaProject javaProject) throws MtjException {
        return MtjProject.getMtjProject((IJavaProject)javaProject);
    }
}

