/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.ui.preferences.PluginPreferenceStore;
import org.eclipse.mtj.core.util.DirUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MtjCoreUiPlugin
extends AbstractUIPlugin {
    private static MtjCoreUiPlugin plugin;
    private IPreferenceStore corePreferenceStore;

    public MtjCoreUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.startTests();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static MtjCoreUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mtj.core.ui", (String)path);
    }

    public static ImageDescriptor getIconImage(String imageName) {
        ImageDescriptor img = null;
        try {
            URL pluginURL = MtjCoreUiPlugin.getDefault().getBundle().getEntry("/");
            URL imgURL = new URL(pluginURL, "icons/" + imageName);
            img = ImageDescriptor.createFromURL((URL)imgURL);
        }
        catch (MalformedURLException e) {
            MtjCorePlugin.log((int)1, (String)"getIconImage", (Throwable)e);
        }
        return img;
    }

    public static void displayError(Shell shell, int severity, int code, String title, String message, Throwable exception) {
        String id = MtjCoreUiPlugin.getDefault().getBundle().getSymbolicName();
        Status status = new Status(severity, id, code, message, exception);
        MtjCoreUiPlugin.getDefault().getLog().log((IStatus)status);
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static Shell getActiveWindowShell() {
        MtjCoreUiPlugin plugin = MtjCoreUiPlugin.getDefault();
        IWorkbenchWindow activeWindow = plugin.getWorkbench().getActiveWorkbenchWindow();
        return activeWindow.getShell();
    }

    public static IPersistentPreferenceStore getCoreProjectPreferenceStore(IProject context) {
        ProjectScope projectScope = new ProjectScope(context);
        return new ScopedPreferenceStore((IScopeContext)projectScope, "mtj.core");
    }

    public IPreferenceStore getCorePreferenceStore() {
        if (this.corePreferenceStore == null) {
            MtjCoreUiPlugin plugin = MtjCoreUiPlugin.getDefault();
            this.corePreferenceStore = new PluginPreferenceStore((Plugin)plugin, plugin.getPluginPreferences());
        }
        return this.corePreferenceStore;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        return MtjCoreUiPlugin.getActiveWorkbenchWindow().getShell();
    }

    private void startTests() {
    }

    public static String getPluginIconsDir() {
        return MtjCoreUiPlugin.getInstallLocation().append("/icons").toString();
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        super.initializeImageRegistry(imageRegistry);
        try {
            ArrayList images = DirUtil.getAllFilesInDirectory((String)MtjCoreUiPlugin.getPluginIconsDir(), (boolean)true, (boolean)true, (String)"*.gif");
            for (String fileName : images) {
                int pos = fileName.indexOf("/icons/");
                if (pos == -1) continue;
                String imageKey = fileName.substring(pos += 7);
                imageRegistry.put(imageKey, ImageDescriptor.createFromURL((URL)new URL("file:" + fileName)));
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public static ImageRegistry getMtjImageRegistry() {
        return MtjCoreUiPlugin.getDefault().getImageRegistry();
    }

    public static String getPluginId() {
        return MtjCoreUiPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static Path getInstallLocation() {
        try {
            Bundle bundle = MtjCoreUiPlugin.getDefault().getBundle();
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(""), null);
            String s1 = FileLocator.resolve((URL)url).getFile();
            if (s1.startsWith("/")) {
                s1 = s1.substring(1);
            }
            String s = (s1 = new Path(s1).toOSString()).endsWith(File.separator) ? s1 : String.valueOf(s1) + File.separator;
            return new Path(s);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

