/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui.util;

import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.mtj.core.ui.util.AbstractSearchScope;

public class MidletSearchScope
extends AbstractSearchScope {
    private IJavaSearchScope[] scopes;

    public MidletSearchScope(IJavaProject javaProject) throws JavaModelException {
        this.scopes = this.createSearchScopes(javaProject);
    }

    public boolean encloses(String resourcePath) {
        boolean encloses = true;
        int i = 0;
        while (encloses && i < this.scopes.length) {
            encloses = this.scopes[i].encloses(resourcePath);
            ++i;
        }
        return encloses;
    }

    public boolean encloses(IJavaElement element) {
        boolean encloses = true;
        int i = 0;
        while (encloses && i < this.scopes.length) {
            encloses = this.scopes[i].encloses(element);
            ++i;
        }
        return encloses;
    }

    public IPath[] enclosingProjectsAndJars() {
        HashSet<IPath> set = new HashSet<IPath>();
        int i = 0;
        while (i < this.scopes.length) {
            IJavaSearchScope scope = this.scopes[i];
            IPath[] scopePaths = scope.enclosingProjectsAndJars();
            int j = 0;
            while (j < scopePaths.length) {
                set.add(scopePaths[j]);
                ++j;
            }
            ++i;
        }
        return set.toArray(new IPath[set.size()]);
    }

    private IJavaSearchScope[] createSearchScopes(IJavaProject javaProject) throws JavaModelException {
        IJavaSearchScope[] scopes = null;
        if (javaProject == null || !javaProject.exists()) {
            IJavaSearchScope searchScope = SearchEngine.createWorkspaceScope();
            scopes = new IJavaSearchScope[]{searchScope};
        } else {
            IType type = javaProject.findType("javax.microedition.midlet.MIDlet");
            IJavaElement[] elements = new IJavaElement[]{javaProject};
            scopes = new IJavaSearchScope[]{SearchEngine.createHierarchyScope((IType)type), SearchEngine.createJavaSearchScope((IJavaElement[])elements), new MidletSuperclassExclusionScope()};
        }
        return scopes;
    }

    private class MidletSuperclassExclusionScope
    extends AbstractSearchScope {
        private MidletSuperclassExclusionScope() {
        }

        public boolean encloses(String resourcePath) {
            boolean excluded = resourcePath.endsWith("java/lang/Object.class") || resourcePath.endsWith("javax/microedition/midlet/MIDlet.class");
            return !excluded;
        }

        public boolean encloses(IJavaElement element) {
            return true;
        }

        public IPath[] enclosingProjectsAndJars() {
            return new IPath[0];
        }
    }
}

