/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.project.midp;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.extension.ProjectExtensionProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.api.model.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.project.midp.Messages;
import org.eclipse.mtj.core.project.midp.preverification.CLDC1_0PreverificationPolicy;
import org.eclipse.mtj.core.project.midp.preverification.CLDC1_1PreverificationPolicy;
import org.eclipse.mtj.core.ui.util.MidletSearchScope;
import org.eclipse.mtj.core.util.CoreUtil;
import org.eclipse.mtj.core.version.Version;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.mtj.extension.devide.config.LibrarySpecification;
import org.eclipse.mtj.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.internal.utils.TemporaryFileManager;
import org.eclipse.mtj.internal.utils.Utils;

public class MidpProjectExtensionProvider
implements ProjectExtensionProvider {
    private static final String DEPLOYMENT_DIRECTORY = "deployed";
    private static final String LAUNCHABLE_CLASSES_FOLDER = "verified/classes";
    private static final String LAUNCHABLE_LIBS_FOLDER = "verified/libs";
    private IPath jadFilePath = null;

    public ProjectType getProjectType() {
        return ProjectType.PROJECT_TYPE_MIDP_LITERAL;
    }

    public Deployment getDeployment(IMtjProject project, String launchableApplication) throws MtjException {
        java.io.File jar = this.findFile(project.getProject(), DEPLOYMENT_DIRECTORY, "jar");
        if (jar == null) {
            throw new MtjException(Messages.MidpProjectExtensionProvider_JarNotFound);
        }
        java.io.File jad = this.findFile(project.getProject(), DEPLOYMENT_DIRECTORY, "jad");
        if (jad == null) {
            throw new MtjException(Messages.MidpProjectExtensionProvider_JadNotFound);
        }
        try {
            this.calculateJADFile(jad, jar, launchableApplication);
        }
        catch (CoreException e) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)2052), (Throwable)e);
        }
        java.io.File[] files = new java.io.File[]{jar, jad};
        MidletDeployment midletDeployment = (MidletDeployment)CoreUtil.createDeployment((java.io.File[])files, (DeploymentType)DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL);
        return midletDeployment;
    }

    public Deployment getDeployment(IMtjProject project) throws MtjException {
        java.io.File jar = this.findFile(project.getProject(), DEPLOYMENT_DIRECTORY, "jar");
        if (jar == null) {
            throw new MtjException(Messages.MidpProjectExtensionProvider_JarNotFound);
        }
        java.io.File jad = this.findFile(project.getProject(), DEPLOYMENT_DIRECTORY, "jad");
        if (jad == null) {
            throw new MtjException(Messages.MidpProjectExtensionProvider_JadNotFound);
        }
        java.io.File[] files = new java.io.File[]{jar, jad};
        MidletDeployment midletDeployment = (MidletDeployment)CoreUtil.createDeployment((java.io.File[])files, (DeploymentType)DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL);
        return midletDeployment;
    }

    protected java.io.File calculateJADFile(java.io.File jadFile, java.io.File srcJar, String midletClass) throws CoreException {
        return this.createSingleClassJadFile(jadFile, srcJar, midletClass);
    }

    private java.io.File createSingleClassJadFile(java.io.File jadFile, java.io.File srcJar, String midletClass) throws CoreException {
        java.io.File tempJadFile = null;
        if (jadFile.exists()) {
            try {
                ColonDelimitedProperties props = new ColonDelimitedProperties();
                FileInputStream contents = new FileInputStream(jadFile);
                props.load((InputStream)contents);
                ((InputStream)contents).close();
                this.getSingleClassJADProperties(midletClass, props);
                java.io.File tempDirectory = TemporaryFileManager.instance.createTempDirectory("launch_", ".mtj");
                java.io.File tgtJar = new java.io.File(tempDirectory, srcJar.getName());
                Utils.copyFile((java.io.File)srcJar, (java.io.File)tgtJar);
                props.setProperty("MIDlet-Jar-URL", srcJar.getName());
                tempJadFile = new java.io.File(tempDirectory, jadFile.getName());
                FileOutputStream fos = new FileOutputStream(tempJadFile);
                props.store((OutputStream)fos, Messages.MidpProjectExtensionProvider_TemporaryManifestFile);
                fos.close();
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.mtj.core.ui", 2052, MtjCoreErrors.getErrorMessage((int)2052), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        return tempJadFile;
    }

    private void getSingleClassJADProperties(String midletClass, ColonDelimitedProperties props) throws CoreException {
        int i = 0;
        while (i < 100) {
            String key = "MIDlet-" + i;
            if (!props.containsKey((Object)key)) break;
            props.remove((Object)key);
            ++i;
        }
        String propValue = String.valueOf(midletClass) + ",," + midletClass;
        props.setProperty("MIDlet-1", propValue);
    }

    private java.io.File findFile(IProject project, String folder2, String fileType) {
        String[] files;
        String folder = project.getLocation().toString();
        final String fType = fileType;
        java.io.File f = new java.io.File(String.valueOf(folder) + "/" + folder2);
        if (f.exists() && (files = f.list(new FilenameFilter(){

            public boolean accept(java.io.File dir, String name) {
                return name.endsWith("." + fType);
            }
        })) != null && files.length > 0) {
            String fol = String.valueOf(folder) + "/" + folder2 + "/" + files[0];
            return new java.io.File(fol);
        }
        return null;
    }

    public String getLaunchableClassesFolder(IProgressMonitor monitor) throws CoreException {
        return LAUNCHABLE_CLASSES_FOLDER;
    }

    public String getDeploymentFolder(IProgressMonitor monitor) throws CoreException {
        return DEPLOYMENT_DIRECTORY;
    }

    public String getLaunchableLibsFolder(IProgressMonitor monitor) throws CoreException {
        return LAUNCHABLE_LIBS_FOLDER;
    }

    public DeploymentType getDeploymentType() throws MtjException {
        return DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL;
    }

    public IJavaSearchScope getJavaSearchScope(IJavaProject javaProject) throws MtjException {
        try {
            return new MidletSearchScope(javaProject);
        }
        catch (JavaModelException e) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)2563), (Throwable)e);
        }
    }

    public IPreverificationPolicy getPreverificationPolicy(RuntimePlatformDefinition targetPlatform) throws MtjException {
        Version version = null;
        for (DeviceConfiguration dc : targetPlatform.getDeviceConfigurations()) {
            if (dc.getVersion() == null) continue;
            Version v = new Version(dc.getVersion());
            if (version != null && version.compareTo(v) <= 0) continue;
            version = v;
        }
        if (version == null || version.getMinor().equals("0")) {
            return new CLDC1_0PreverificationPolicy();
        }
        return new CLDC1_1PreverificationPolicy();
    }

    public void initializeNewProject(IJavaProject javaProject, IProgressMonitor monitor) throws MtjException {
    }

    private String getJarFileName(IJavaProject javaProject) {
        return String.valueOf(this.getProjectNameWithoutSpaces(javaProject)) + ".jar";
    }

    private String getProjectNameWithoutSpaces(IJavaProject javaProject) {
        String projectName = javaProject.getProject().getName();
        return projectName.replace(' ', '_');
    }

    private ColonDelimitedProperties getDefaultApplicationDescriptorProperties(IMtjProject mtjproject) throws CoreException, MtjException {
        ColonDelimitedProperties descriptor = new ColonDelimitedProperties();
        descriptor.setProperty("MIDlet-Jar-URL", this.getJarFileName(mtjproject.getJavaProject()));
        descriptor.setProperty("MIDlet-Name", String.valueOf(mtjproject.getProject().getName()) + " Midlet Suite");
        descriptor.setProperty("MIDlet-Vendor", Messages.MidpProjectExtensionProvider_MidletSuiteVendor);
        descriptor.setProperty("MIDlet-Version", "1.0.0");
        DeviceConfiguration dc = null;
        DeviceProfile dp = null;
        Project project = mtjproject.getProjectData();
        TargetDevice targetDevice = project.getDefaultTargetDevice();
        if (targetDevice != null) {
            dc = (DeviceConfiguration)targetDevice.getRuntimePlatform().getDeviceConfigurations().get(0);
            dp = (DeviceProfile)targetDevice.getRuntimePlatform().getDeviceProfiles().get(0);
            String configVersion = null;
            LibrarySpecification ls = this.getCorrConfiguration(dc);
            if (ls != null) {
                configVersion = ls.getIdentifier();
            }
            if (configVersion != null) {
                descriptor.setProperty("MicroEdition-Configuration", configVersion);
            }
            String profileVersion = null;
            ls = this.getCorrProfile(dp);
            if (ls != null) {
                profileVersion = ls.getIdentifier();
            }
            if (profileVersion != null) {
                descriptor.setProperty("MicroEdition-Profile", profileVersion);
            }
        }
        return descriptor;
    }

    private LibrarySpecification getCorrConfiguration(DeviceConfiguration dc) throws CoreException {
        LibrarySpecification[] lss = MtjDevIdePlugin.getConfigurationSpecifications();
        int i = 0;
        while (i < lss.length) {
            Version v = new Version(dc.getVersion());
            if (lss[i].getVersion().equals(v)) {
                return lss[i];
            }
            ++i;
        }
        return null;
    }

    private LibrarySpecification getCorrProfile(DeviceProfile dp) throws CoreException {
        LibrarySpecification[] lss = MtjDevIdePlugin.getProfileSpecifications();
        int i = 0;
        while (i < lss.length) {
            Version v = new Version(dp.getVersion());
            if (lss[i].getVersion().equals(v)) {
                return lss[i];
            }
            ++i;
        }
        return null;
    }

    public class MtjFile
    extends File {
        public MtjFile(IPath path, Workspace container) {
            super(path, container);
        }

        public IPath getLocation() {
            return this.getLocalManager().locationFor((IResource)this);
        }
    }
}

